/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.ds;

import com.baomidou.dynamic.datasource.enums.SeataMode;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ItemDataSource
extends AbstractHussarDataSource
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ItemDataSource.class);
    private String name;
    private String schemaName;
    private DataSource realDataSource;
    private DataSource dataSource;
    private Boolean p6spy;
    private Boolean seata;
    private SeataMode seataMode;

    public ItemDataSource(String poolName, DbType dbType, String driverClassName, String url, String username, String password, DataSource realDataSource, DataSource dataSource, Boolean p6spy, Boolean seata, SeataMode seataMode) {
        super(poolName, dbType, driverClassName, url, username, password);
        this.name = poolName;
        this.realDataSource = realDataSource;
        this.dataSource = dataSource;
        this.p6spy = p6spy;
        this.seata = seata;
        this.seataMode = seataMode;
    }

    public ItemDataSource(String poolName, DbType dbType, String driverClassName, String url, String username, String password, DataSource realDataSource, DataSource dataSource, Boolean p6spy, Boolean seata, SeataMode seataMode, String schemaName) {
        super(poolName, dbType, driverClassName, url, username, password);
        this.name = poolName;
        this.realDataSource = realDataSource;
        this.dataSource = dataSource;
        this.p6spy = p6spy;
        this.seata = seata;
        this.seataMode = seataMode;
        this.schemaName = schemaName;
    }

    @Override
    protected DataSource determineDataSource() {
        return this.dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return super.isWrapperFor(iface) || iface.isInstance(this.realDataSource) || iface.isInstance(this.dataSource);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        if (iface.isInstance(this.realDataSource)) {
            return (T)this.realDataSource;
        }
        if (iface.isInstance(this.dataSource)) {
            return (T)this.dataSource;
        }
        return null;
    }

    @Override
    public void close() {
        Class<?> clazz = this.realDataSource.getClass();
        try {
            Method closeMethod = ReflectionUtils.findMethod(clazz, (String)"close");
            if (closeMethod != null) {
                closeMethod.invoke((Object)this.realDataSource, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.warn("dynamic-datasource close the datasource named [{}] failed,", (Object)this.name, (Object)e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemDataSource)) {
            return false;
        }
        ItemDataSource other = (ItemDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$p6spy = this.getP6spy();
        Boolean other$p6spy = other.getP6spy();
        if (!(this$p6spy == null ? other$p6spy == null : ((Object)this$p6spy).equals(other$p6spy))) {
            return false;
        }
        Boolean this$seata = this.getSeata();
        Boolean other$seata = other.getSeata();
        if (!(this$seata == null ? other$seata == null : ((Object)this$seata).equals(other$seata))) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (!(this$name == null ? other$name == null : this$name.equals(other$name))) {
            return false;
        }
        DataSource this$realDataSource = this.getRealDataSource();
        DataSource other$realDataSource = other.getRealDataSource();
        if (!(this$realDataSource == null ? other$realDataSource == null : this$realDataSource.equals(other$realDataSource))) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (!(this$dataSource == null ? other$dataSource == null : this$dataSource.equals(other$dataSource))) {
            return false;
        }
        SeataMode this$seataMode = this.getSeataMode();
        SeataMode other$seataMode = other.getSeataMode();
        return this$seataMode == null ? other$seataMode == null : ((Object)((Object)this$seataMode)).equals((Object)other$seataMode);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemDataSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $p6spy = this.getP6spy();
        result = result * 59 + ($p6spy == null ? 43 : ((Object)$p6spy).hashCode());
        Boolean $seata = this.getSeata();
        result = result * 59 + ($seata == null ? 43 : ((Object)$seata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DataSource $realDataSource = this.getRealDataSource();
        result = result * 59 + ($realDataSource == null ? 43 : $realDataSource.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        SeataMode $seataMode = this.getSeataMode();
        result = result * 59 + ($seataMode == null ? 43 : ((Object)((Object)$seataMode)).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public DataSource getRealDataSource() {
        return this.realDataSource;
    }

    public void setRealDataSource(DataSource realDataSource) {
        this.realDataSource = realDataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Boolean getP6spy() {
        return this.p6spy;
    }

    public void setP6spy(Boolean p6spy) {
        this.p6spy = p6spy;
    }

    public Boolean getSeata() {
        return this.seata;
    }

    public void setSeata(Boolean seata) {
        this.seata = seata;
    }

    public SeataMode getSeataMode() {
        return this.seataMode;
    }

    public void setSeataMode(SeataMode seataMode) {
        this.seataMode = seataMode;
    }
}

