/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.qianfan.core.auth;

import com.baidubce.qianfan.core.QianfanConfig;
import com.baidubce.qianfan.core.auth.IAuth;
import com.baidubce.qianfan.model.OAuthErrorResponse;
import com.baidubce.qianfan.model.OAuthResponse;
import com.baidubce.qianfan.model.exception.AuthException;
import com.baidubce.qianfan.model.exception.QianfanException;
import com.baidubce.qianfan.model.exception.RequestException;
import com.baidubce.qianfan.util.Json;
import com.baidubce.qianfan.util.StringUtils;
import com.baidubce.qianfan.util.http.HttpClient;
import com.baidubce.qianfan.util.http.HttpRequest;
import com.baidubce.qianfan.util.http.HttpResponse;
import java.lang.reflect.Type;
import java.net.URI;

public class QianfanOAuth
implements IAuth {
    private static final String OAUTH_URL = "%s/oauth/2.0/token?grant_type=client_credentials&client_id=%s&client_secret=%s";
    private static final String ACCESS_TOKEN = "access_token";
    private static final long EXPIRE_OFFSET_SECONDS = 10L;
    private final String apiKey;
    private final String secretKey;
    private String token;
    private volatile long tokenExpireAt;

    public QianfanOAuth(String apiKey, String secretKey) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    @Override
    public HttpRequest signRequest(HttpRequest request) {
        String accessToken = this.getToken();
        String url = request.getUrl();
        url = URI.create(url).getQuery() == null ? url + "?access_token=" + accessToken : url + "&access_token=" + accessToken;
        return request.url(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToken() {
        if (this.isTokenExpired()) {
            QianfanOAuth qianfanOAuth = this;
            synchronized (qianfanOAuth) {
                if (this.isTokenExpired()) {
                    this.token = this.sign();
                    long expiresIn = QianfanConfig.getAccessTokenRefreshMinInterval().intValue();
                    if (expiresIn > 10L) {
                        expiresIn -= 10L;
                    }
                    this.tokenExpireAt = System.currentTimeMillis() / 1000L + expiresIn;
                }
            }
        }
        return this.token;
    }

    private boolean isTokenExpired() {
        return System.currentTimeMillis() / 1000L > this.tokenExpireAt;
    }

    private String sign() {
        String url = String.format(OAUTH_URL, QianfanConfig.getBaseUrl(), this.apiKey, this.secretKey);
        try {
            HttpResponse resp = HttpClient.request().get(url).executeJson((Type)((Object)OAuthResponse.class));
            if (resp.getCode() > 400 || StringUtils.isEmpty(((OAuthResponse)resp.getBody()).getAccessToken())) {
                OAuthErrorResponse errorResp = Json.deserialize(resp.getStringBody(), OAuthErrorResponse.class);
                throw new AuthException("Auth failed with error", errorResp);
            }
            return ((OAuthResponse)resp.getBody()).getAccessToken();
        }
        catch (QianfanException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RequestException(String.format("Auth request failed: %s", e.getMessage()), e);
        }
    }
}

