/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.NatGatewayInner;
import com.azure.resourcemanager.network.fluent.models.PublicIpPrefixPropertiesFormatInner;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpPrefixSku;
import com.azure.resourcemanager.network.models.ReferencedPublicIpAddress;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class PublicIpPrefixInner
extends Resource {
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="sku")
    private PublicIpPrefixSku sku;
    @JsonProperty(value="properties")
    private PublicIpPrefixPropertiesFormatInner innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public PublicIpPrefixInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public PublicIpPrefixSku sku() {
        return this.sku;
    }

    public PublicIpPrefixInner withSku(PublicIpPrefixSku sku) {
        this.sku = sku;
        return this;
    }

    private PublicIpPrefixPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public PublicIpPrefixInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String id() {
        return this.id;
    }

    public PublicIpPrefixInner withId(String id) {
        this.id = id;
        return this;
    }

    public PublicIpPrefixInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PublicIpPrefixInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressVersion();
    }

    public PublicIpPrefixInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpPrefixPropertiesFormatInner();
        }
        this.innerProperties().withPublicIpAddressVersion(publicIpAddressVersion);
        return this;
    }

    public List<IpTag> ipTags() {
        return this.innerProperties() == null ? null : this.innerProperties().ipTags();
    }

    public PublicIpPrefixInner withIpTags(List<IpTag> ipTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpPrefixPropertiesFormatInner();
        }
        this.innerProperties().withIpTags(ipTags);
        return this;
    }

    public Integer prefixLength() {
        return this.innerProperties() == null ? null : this.innerProperties().prefixLength();
    }

    public PublicIpPrefixInner withPrefixLength(Integer prefixLength) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpPrefixPropertiesFormatInner();
        }
        this.innerProperties().withPrefixLength(prefixLength);
        return this;
    }

    public String ipPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().ipPrefix();
    }

    public List<ReferencedPublicIpAddress> publicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddresses();
    }

    public SubResource loadBalancerFrontendIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerFrontendIpConfiguration();
    }

    public SubResource customIpPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().customIpPrefix();
    }

    public PublicIpPrefixInner withCustomIpPrefix(SubResource customIpPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpPrefixPropertiesFormatInner();
        }
        this.innerProperties().withCustomIpPrefix(customIpPrefix);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public NatGatewayInner natGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().natGateway();
    }

    public PublicIpPrefixInner withNatGateway(NatGatewayInner natGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicIpPrefixPropertiesFormatInner();
        }
        this.innerProperties().withNatGateway(natGateway);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

