/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.Capacity;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKeysMetadata;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.RestoreParameters;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class DatabaseAccountCreateUpdateParameters
extends ArmResourceProperties {
    @JsonProperty(value="kind")
    private DatabaseAccountKind kind;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties", required=true)
    private DatabaseAccountCreateUpdateProperties innerProperties = new DatabaseAccountCreateUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseAccountCreateUpdateParameters.class);

    public DatabaseAccountKind kind() {
        return this.kind;
    }

    public DatabaseAccountCreateUpdateParameters withKind(DatabaseAccountKind kind) {
        this.kind = kind;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public DatabaseAccountCreateUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private DatabaseAccountCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public DatabaseAccountCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public DatabaseAccountCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public ConsistencyPolicy consistencyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().consistencyPolicy();
    }

    public DatabaseAccountCreateUpdateParameters withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withConsistencyPolicy(consistencyPolicy);
        return this;
    }

    public List<Location> locations() {
        return this.innerProperties() == null ? null : this.innerProperties().locations();
    }

    public DatabaseAccountCreateUpdateParameters withLocations(List<Location> locations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withLocations(locations);
        return this;
    }

    public String databaseAccountOfferType() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseAccountOfferType();
    }

    public DatabaseAccountCreateUpdateParameters withDatabaseAccountOfferType(String databaseAccountOfferType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withDatabaseAccountOfferType(databaseAccountOfferType);
        return this;
    }

    public List<IpAddressOrRange> ipRules() {
        return this.innerProperties() == null ? null : this.innerProperties().ipRules();
    }

    public DatabaseAccountCreateUpdateParameters withIpRules(List<IpAddressOrRange> ipRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withIpRules(ipRules);
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isVirtualNetworkFilterEnabled();
    }

    public DatabaseAccountCreateUpdateParameters withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withIsVirtualNetworkFilterEnabled(isVirtualNetworkFilterEnabled);
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAutomaticFailover();
    }

    public DatabaseAccountCreateUpdateParameters withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withEnableAutomaticFailover(enableAutomaticFailover);
        return this;
    }

    public List<Capability> capabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().capabilities();
    }

    public DatabaseAccountCreateUpdateParameters withCapabilities(List<Capability> capabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withCapabilities(capabilities);
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkRules();
    }

    public DatabaseAccountCreateUpdateParameters withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withVirtualNetworkRules(virtualNetworkRules);
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().enableMultipleWriteLocations();
    }

    public DatabaseAccountCreateUpdateParameters withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withEnableMultipleWriteLocations(enableMultipleWriteLocations);
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.innerProperties() == null ? null : this.innerProperties().enableCassandraConnector();
    }

    public DatabaseAccountCreateUpdateParameters withEnableCassandraConnector(Boolean enableCassandraConnector) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withEnableCassandraConnector(enableCassandraConnector);
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.innerProperties() == null ? null : this.innerProperties().connectorOffer();
    }

    public DatabaseAccountCreateUpdateParameters withConnectorOffer(ConnectorOffer connectorOffer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withConnectorOffer(connectorOffer);
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().disableKeyBasedMetadataWriteAccess();
    }

    public DatabaseAccountCreateUpdateParameters withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withDisableKeyBasedMetadataWriteAccess(disableKeyBasedMetadataWriteAccess);
        return this;
    }

    public String keyVaultKeyUri() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultKeyUri();
    }

    public DatabaseAccountCreateUpdateParameters withKeyVaultKeyUri(String keyVaultKeyUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withKeyVaultKeyUri(keyVaultKeyUri);
        return this;
    }

    public String defaultIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultIdentity();
    }

    public DatabaseAccountCreateUpdateParameters withDefaultIdentity(String defaultIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withDefaultIdentity(defaultIdentity);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public DatabaseAccountCreateUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Boolean enableFreeTier() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFreeTier();
    }

    public DatabaseAccountCreateUpdateParameters withEnableFreeTier(Boolean enableFreeTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withEnableFreeTier(enableFreeTier);
        return this;
    }

    public ApiProperties apiProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().apiProperties();
    }

    public DatabaseAccountCreateUpdateParameters withApiProperties(ApiProperties apiProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withApiProperties(apiProperties);
        return this;
    }

    public Boolean enableAnalyticalStorage() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAnalyticalStorage();
    }

    public DatabaseAccountCreateUpdateParameters withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withEnableAnalyticalStorage(enableAnalyticalStorage);
        return this;
    }

    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().analyticalStorageConfiguration();
    }

    public DatabaseAccountCreateUpdateParameters withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withAnalyticalStorageConfiguration(analyticalStorageConfiguration);
        return this;
    }

    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public DatabaseAccountCreateUpdateParameters withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public BackupPolicy backupPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().backupPolicy();
    }

    public DatabaseAccountCreateUpdateParameters withBackupPolicy(BackupPolicy backupPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withBackupPolicy(backupPolicy);
        return this;
    }

    public List<CorsPolicy> cors() {
        return this.innerProperties() == null ? null : this.innerProperties().cors();
    }

    public DatabaseAccountCreateUpdateParameters withCors(List<CorsPolicy> cors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withCors(cors);
        return this;
    }

    public NetworkAclBypass networkAclBypass() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAclBypass();
    }

    public DatabaseAccountCreateUpdateParameters withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withNetworkAclBypass(networkAclBypass);
        return this;
    }

    public List<String> networkAclBypassResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAclBypassResourceIds();
    }

    public DatabaseAccountCreateUpdateParameters withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withNetworkAclBypassResourceIds(networkAclBypassResourceIds);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public DatabaseAccountCreateUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public RestoreParameters restoreParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().restoreParameters();
    }

    public DatabaseAccountCreateUpdateParameters withRestoreParameters(RestoreParameters restoreParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withRestoreParameters(restoreParameters);
        return this;
    }

    public Capacity capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    public DatabaseAccountCreateUpdateParameters withCapacity(Capacity capacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withCapacity(capacity);
        return this;
    }

    public DatabaseAccountKeysMetadata keysMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().keysMetadata();
    }

    public Boolean enablePartitionMerge() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePartitionMerge();
    }

    public DatabaseAccountCreateUpdateParameters withEnablePartitionMerge(Boolean enablePartitionMerge) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAccountCreateUpdateProperties();
        }
        this.innerProperties().withEnablePartitionMerge(enablePartitionMerge);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model DatabaseAccountCreateUpdateParameters"));
        }
        this.innerProperties().validate();
    }
}

