/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.repository.Query;
import com.azure.spring.data.cosmos.repository.query.CosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.query.SimpleCosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CosmosQueryMethod
extends QueryMethod {
    private CosmosEntityMetadata<?> metadata;
    private final String annotatedQueryValue;

    public CosmosQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.annotatedQueryValue = this.findAnnotatedQuery(method).orElse(null);
    }

    public EntityMetadata<?> getEntityInformation() {
        Class domainType = this.getDomainClass();
        CosmosEntityInformation entityInformation = new CosmosEntityInformation(domainType);
        this.metadata = new SimpleCosmosEntityMetadata(domainType, entityInformation);
        return this.metadata;
    }

    public boolean hasAnnotatedQuery() {
        return this.annotatedQueryValue != null;
    }

    @Nullable
    public String getQueryAnnotation() {
        return this.annotatedQueryValue;
    }

    private Optional<String> findAnnotatedQuery(Method method) {
        return Optional.ofNullable((Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class)).map(Query::value).filter(StringUtils::hasText);
    }
}

