/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.generator;

import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.core.query.Criteria;
import com.azure.spring.data.cosmos.core.query.CriteriaType;
import com.azure.spring.data.cosmos.exception.IllegalQueryException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.Pair;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractQueryGenerator {
    private static String tableName = "";
    private static final String CONSTANT_TABLE_NAME = "r";

    protected AbstractQueryGenerator() {
    }

    private String generateQueryParameter(@NonNull String subject, int counter) {
        return subject.replaceAll("[^a-zA-Z\\d]", "_") + counter;
    }

    private String generateUnaryQuery(@NonNull Criteria criteria) {
        Assert.isTrue((boolean)criteria.getSubjectValues().isEmpty(), (String)"Unary criteria should have no one subject value");
        Assert.isTrue((boolean)CriteriaType.isUnary(criteria.getType()), (String)"Criteria type should be unary operation");
        String subject = criteria.getSubject();
        if (CriteriaType.isFunction(criteria.getType())) {
            return String.format("%s(r.%s)", criteria.getType().getSqlKeyword(), subject);
        }
        return String.format("r.%s %s", subject, criteria.getType().getSqlKeyword());
    }

    private String generateBinaryQuery(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters, int counter) {
        Assert.isTrue((criteria.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Binary criteria should have only one subject value");
        Assert.isTrue((boolean)CriteriaType.isBinary(criteria.getType()), (String)"Criteria type should be binary operation");
        String subject = criteria.getSubject();
        Object subjectValue = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(0));
        String parameter = this.generateQueryParameter(subject, counter);
        Part.IgnoreCaseType ignoreCase = criteria.getIgnoreCase();
        String sqlKeyword = criteria.getType().getSqlKeyword();
        parameters.add((Pair<String, Object>)Pair.of((Object)parameter, (Object)subjectValue));
        if (CriteriaType.isFunction(criteria.getType())) {
            return this.getFunctionCondition(ignoreCase, sqlKeyword, subject, parameter, CriteriaType.isFunctionWithCaseSensitiveSupport(criteria.getType()));
        }
        if (criteria.getType() == CriteriaType.IS_EQUAL && ignoreCase != Part.IgnoreCaseType.NEVER && subjectValue instanceof String) {
            return this.getFunctionCondition(ignoreCase, CriteriaType.STRING_EQUALS.getSqlKeyword(), subject, parameter, true);
        }
        return this.getCondition(ignoreCase, sqlKeyword, subject, parameter);
    }

    private String getCondition(Part.IgnoreCaseType ignoreCase, String sqlKeyword, String subject, String parameter) {
        if (Part.IgnoreCaseType.NEVER == ignoreCase) {
            return String.format("r.%s %s @%s", subject, sqlKeyword, parameter);
        }
        return String.format("UPPER(r.%s) %s UPPER(@%s)", subject, sqlKeyword, parameter);
    }

    private String getFunctionCondition(Part.IgnoreCaseType ignoreCase, String sqlKeyword, String subject, String parameter, boolean takesCaseSensitiveParam) {
        if (Part.IgnoreCaseType.NEVER == ignoreCase) {
            return String.format("%s(r.%s, @%s)", sqlKeyword, subject, parameter);
        }
        if (takesCaseSensitiveParam) {
            return String.format("%s(r.%s, @%s, true)", sqlKeyword, subject, parameter);
        }
        return String.format("%s(UPPER(r.%s), UPPER(@%s))", sqlKeyword, subject, parameter);
    }

    private String generateBetween(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters, int counter) {
        String subject = criteria.getSubject();
        Object value1 = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(0));
        Object value2 = MappingCosmosConverter.toCosmosDbValue(criteria.getSubjectValues().get(1));
        String subject1 = subject + "start";
        String subject2 = subject + "end";
        String parameter1 = this.generateQueryParameter(subject1, counter);
        String parameter2 = this.generateQueryParameter(subject2, counter);
        String keyword = criteria.getType().getSqlKeyword();
        parameters.add((Pair<String, Object>)Pair.of((Object)parameter1, (Object)value1));
        parameters.add((Pair<String, Object>)Pair.of((Object)parameter2, (Object)value2));
        return String.format("(r.%s %s @%s AND @%s)", subject, keyword, parameter1, parameter2);
    }

    private String generateClosedQuery(@NonNull String left, @NonNull String right, CriteriaType type) {
        Assert.isTrue((CriteriaType.isClosed(type) && CriteriaType.isBinary(type) ? 1 : 0) != 0, (String)"Criteria type should be binary and closure operation");
        return String.format("(%s %s %s)", left, type.getSqlKeyword(), right);
    }

    private String generateInQuery(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters) {
        Assert.isTrue((criteria.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Criteria should have only one subject value");
        if (!(criteria.getSubjectValues().get(0) instanceof Collection)) {
            throw new IllegalQueryException("IN keyword requires Collection type in parameters");
        }
        Collection values = (Collection)criteria.getSubjectValues().get(0);
        ArrayList<CallSite> paras = new ArrayList<CallSite>();
        for (Object o : values) {
            if (o instanceof String || o instanceof Integer || o instanceof Long || o instanceof Boolean) {
                String key = "p" + parameters.size();
                paras.add((CallSite)((Object)("@" + key)));
                parameters.add((Pair<String, Object>)Pair.of((Object)key, o));
                continue;
            }
            throw new IllegalQueryException("IN keyword Range only support Number and String type.");
        }
        return String.format("r.%s %s (%s)", criteria.getSubject(), criteria.getType().getSqlKeyword(), String.join((CharSequence)",", paras));
    }

    private String generateQueryBody(@NonNull Criteria criteria, @NonNull List<Pair<String, Object>> parameters, @NonNull AtomicInteger counter) {
        CriteriaType type = criteria.getType();
        switch (type) {
            case ALL: {
                return "";
            }
            case IN: 
            case NOT_IN: {
                return this.generateInQuery(criteria, parameters);
            }
            case BETWEEN: {
                return this.generateBetween(criteria, parameters, counter.getAndIncrement());
            }
            case IS_NULL: 
            case IS_NOT_NULL: 
            case FALSE: 
            case TRUE: {
                return this.generateUnaryQuery(criteria);
            }
            case IS_EQUAL: 
            case NOT: 
            case BEFORE: 
            case AFTER: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case CONTAINING: 
            case NOT_CONTAINING: 
            case ENDS_WITH: 
            case STARTS_WITH: 
            case ARRAY_CONTAINS: 
            case STRING_EQUALS: {
                return this.generateBinaryQuery(criteria, parameters, counter.getAndIncrement());
            }
            case AND: 
            case OR: {
                Assert.isTrue((criteria.getSubCriteria().size() == 2 ? 1 : 0) != 0, (String)"criteria should have two SubCriteria");
                String left = this.generateQueryBody(criteria.getSubCriteria().get(0), parameters, counter);
                String right = this.generateQueryBody(criteria.getSubCriteria().get(1), parameters, counter);
                return this.generateClosedQuery(left, right, type);
            }
        }
        throw new UnsupportedOperationException("unsupported Criteria type: " + String.valueOf((Object)type));
    }

    @NonNull
    private Pair<String, List<Pair<String, Object>>> generateQueryBody(@NonNull CosmosQuery query, @NonNull AtomicInteger counter) {
        ArrayList<Pair<String, Object>> parameters = new ArrayList<Pair<String, Object>>();
        String queryString = "";
        if (query.getCriteria() != null) {
            queryString = this.generateQueryBody(query.getCriteria(), parameters, counter);
        }
        if (StringUtils.hasText((String)queryString)) {
            queryString = String.join((CharSequence)" ", "WHERE", queryString);
        }
        return Pair.of((Object)queryString, parameters);
    }

    private static String getParameter(@NonNull Sort.Order order) {
        Assert.isTrue((!order.isIgnoreCase() ? 1 : 0) != 0, (String)"Ignore case is not supported");
        String direction = order.isDescending() ? "DESC" : "ASC";
        return String.format("%s.%s %s", tableName, order.getProperty(), direction);
    }

    static String generateQuerySort(@NonNull Sort sort, @NonNull String inputTableName) {
        if (sort.isUnsorted()) {
            return "";
        }
        tableName = inputTableName;
        String queryTail = "ORDER BY";
        List subjects = sort.stream().map(AbstractQueryGenerator::getParameter).collect(Collectors.toList());
        return "ORDER BY " + String.join((CharSequence)",", subjects);
    }

    @NonNull
    private String generateQueryTail(@NonNull CosmosQuery query) {
        ArrayList<String> queryTails = new ArrayList<String>();
        queryTails.add(AbstractQueryGenerator.generateQuerySort(query.getSort(), CONSTANT_TABLE_NAME));
        return String.join((CharSequence)" ", queryTails.stream().filter(StringUtils::hasText).collect(Collectors.toList()));
    }

    protected SqlQuerySpec generateCosmosCountQuery(@NonNull CosmosQuery query, @NonNull String queryHead) {
        AtomicInteger counter = new AtomicInteger();
        Pair<String, List<Pair<String, Object>>> queryBody = this.generateQueryBody(query, counter);
        String queryString = String.join((CharSequence)" ", queryHead, (CharSequence)queryBody.getFirst(), this.generateQueryTail(query));
        List parameters = (List)queryBody.getSecond();
        List sqlParameters = parameters.stream().map(p -> new SqlParameter("@" + (String)p.getFirst(), MappingCosmosConverter.toCosmosDbValue(p.getSecond()))).collect(Collectors.toList());
        return new SqlQuerySpec(queryString, sqlParameters);
    }

    protected SqlQuerySpec generateCosmosQuery(@NonNull CosmosQuery query, @NonNull String queryHead) {
        AtomicInteger counter = new AtomicInteger();
        Pair<String, List<Pair<String, Object>>> queryBody = this.generateQueryBody(query, counter);
        String queryString = String.join((CharSequence)" ", queryHead, (CharSequence)queryBody.getFirst(), this.generateQueryTail(query));
        List parameters = (List)queryBody.getSecond();
        List sqlParameters = parameters.stream().map(p -> new SqlParameter("@" + (String)p.getFirst(), MappingCosmosConverter.toCosmosDbValue(p.getSecond()))).collect(Collectors.toList());
        if (query.getLimit() > 0) {
            queryString = queryString + " OFFSET " + query.getOffset() + " LIMIT " + query.getLimit();
        }
        return new SqlQuerySpec(queryString, sqlParameters);
    }
}

