/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

class QueryParameter {
    private final String name;
    private final String value;
    private List<String> values;
    private volatile String cachedStringValue;

    QueryParameter(String name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.value = value;
    }

    QueryParameter(String name, List<String> values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(values, "'values' cannot be null");
        this.name = name;
        this.value = null;
        this.values = new LinkedList<String>(values);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        this.checkCachedStringValue();
        return this.cachedStringValue;
    }

    public String[] getValues() {
        if (this.values == null) {
            return new String[]{this.value};
        }
        return this.values.toArray(new String[0]);
    }

    public List<String> getValuesList() {
        if (this.values == null) {
            return Collections.unmodifiableList(Arrays.asList(this.value));
        }
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(String newValue) {
        if (this.values == null) {
            this.values = new LinkedList<String>();
            this.values.add(this.value);
        }
        this.values.add(newValue);
        this.cachedStringValue = null;
    }

    public String toString() {
        this.checkCachedStringValue();
        return this.name + "=" + this.cachedStringValue;
    }

    private void checkCachedStringValue() {
        if (this.cachedStringValue == null) {
            this.cachedStringValue = this.values == null ? this.value : String.join((CharSequence)",", this.values);
        }
    }
}

