/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.SliceInputStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public final class FileContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(FileContent.class);
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final Path file;
    private final int chunkSize;
    private final long position;
    private final long length;
    private final AtomicReference<byte[]> bytes = new AtomicReference();

    public FileContent(Path file, int chunkSize, Long position, Long length) {
        this.file = FileContent.validateFile(file);
        this.chunkSize = FileContent.validateChunkSize(chunkSize);
        long fileLength = file.toFile().length();
        this.position = FileContent.validatePosition(position);
        this.length = FileContent.validateLength(length, fileLength, this.position);
    }

    private static Path validateFile(Path file) {
        Objects.requireNonNull(file, "'file' cannot be null.");
        if (!file.toFile().exists()) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(new FileNotFoundException("File does not exist " + file)));
        }
        return file;
    }

    private static int validateChunkSize(int chunkSize) {
        if (chunkSize <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'chunkSize' cannot be less than or equal to 0."));
        }
        return chunkSize;
    }

    private static long validatePosition(Long position) {
        if (position != null && position < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'position' cannot be negative."));
        }
        return position != null ? position : 0L;
    }

    private static long validateLength(Long length, long fileLength, long position) {
        if (length != null && length < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'length' cannot be negative."));
        }
        long maxAvailableLength = fileLength - position;
        return length == null ? maxAvailableLength : Math.min(length, maxAvailableLength);
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        byte[] data = this.bytes.get();
        if (data == null) {
            this.bytes.set(this.getBytes());
            data = this.bytes.get();
        }
        return data;
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserialize(this.toStream(), typeReference);
    }

    @Override
    public InputStream toStream() {
        try {
            return new SliceInputStream(new BufferedInputStream(new FileInputStream(this.file.toFile()), this.chunkSize), this.position, this.length);
        }
        catch (FileNotFoundException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException("File not found " + this.file, e));
        }
    }

    @Override
    public ByteBuffer toByteBuffer() {
        MappedByteBuffer mappedByteBuffer;
        block9: {
            if (this.length > Integer.MAX_VALUE) {
                throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("'length' cannot be greater than %d when mapping file to ByteBuffer.", Integer.MAX_VALUE)));
            }
            FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);
            try {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.position, this.length);
                if (fileChannel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(exception));
                }
            }
            fileChannel.close();
        }
        return mappedByteBuffer;
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return Flux.using(() -> FileChannel.open(this.file, new OpenOption[0]), channel -> Flux.generate(() -> 0, (count, sink) -> {
            if ((long)count.intValue() == this.length) {
                sink.complete();
                return count;
            }
            int readCount = (int)Math.min((long)this.chunkSize, this.length - (long)count.intValue());
            try {
                sink.next((Object)channel.map(FileChannel.MapMode.READ_ONLY, this.position + (long)count.intValue(), readCount));
            }
            catch (IOException ex) {
                sink.error((Throwable)ex);
            }
            return count + readCount;
        }), channel -> {
            try {
                channel.close();
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)ex));
            }
        });
    }

    public Path getFile() {
        return this.file;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    private byte[] getBytes() {
        if (this.length > 0x7FFFFFF7L) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("'length' cannot be greater than %d when buffering content.", 0x7FFFFFF7)));
        }
        byte[] bytes = new byte[(int)this.length];
        this.toByteBuffer().get(bytes);
        return bytes;
    }
}

