/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CookiePolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(CookiePolicy.class);
    private final CookieHandler cookies = new CookieManager();

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            HttpRequest httpRequest = context.getHttpRequest();
            URI uri = httpRequest.getUrl().toURI();
            HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
            for (HttpHeader header : httpRequest.getHeaders()) {
                cookieHeaders.put(header.getName(), header.getValuesList());
            }
            Map<String, List<String>> requestCookies = this.cookies.get(uri, cookieHeaders);
            for (Map.Entry<String, List<String>> entry : requestCookies.entrySet()) {
                httpRequest.getHeaders().set(entry.getKey(), entry.getValue());
            }
            return next.process().map(httpResponse -> {
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                for (HttpHeader header : httpResponse.getHeaders()) {
                    responseHeaders.put(header.getName(), header.getValuesList());
                }
                try {
                    this.cookies.put(uri, responseHeaders);
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
                }
                return httpResponse;
            });
        }
        catch (IOException | URISyntaxException e) {
            return Mono.error((Throwable)e);
        }
    }
}

