/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.models;

import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.test.models.NetworkCallRecord;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Predicate;

public class RecordedData
implements JsonSerializable<RecordedData> {
    private final Object networkCallRecordsLock = new Object();
    private final Object variablesLock = new Object();
    private final LinkedList<NetworkCallRecord> networkCallRecords = new LinkedList();
    private final LinkedList<String> variables = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkCallRecord findFirstAndRemoveNetworkCall(Predicate<NetworkCallRecord> isMatch) {
        Objects.requireNonNull(isMatch, "'isMatch' cannot be null.");
        Object object = this.networkCallRecordsLock;
        synchronized (object) {
            Iterator iterator = this.networkCallRecords.iterator();
            while (iterator.hasNext()) {
                NetworkCallRecord next = (NetworkCallRecord)iterator.next();
                if (!isMatch.test(next)) continue;
                iterator.remove();
                return next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkCall(NetworkCallRecord record) {
        Objects.requireNonNull(record, "'record' cannot be null.");
        Object object = this.networkCallRecordsLock;
        synchronized (object) {
            this.networkCallRecords.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariable(String variable) {
        Objects.requireNonNull(variable, "'variable' cannot be null.");
        Object object = this.variablesLock;
        synchronized (object) {
            this.variables.add(variable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeVariable() {
        Object object = this.variablesLock;
        synchronized (object) {
            return this.variables.removeFirst();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeArrayField("networkCallRecords", this.networkCallRecords, JsonWriter::writeJson).writeArrayField("variables", this.variables, JsonWriter::writeString).writeEndObject();
    }

    public static RecordedData fromJson(JsonReader jsonReader) throws IOException {
        return TestingHelpers.readObject(jsonReader, RecordedData::new, (recordedData, fieldName, reader) -> {
            if ("networkCallRecords".equals(fieldName)) {
                recordedData.networkCallRecords.addAll(reader.readArray(NetworkCallRecord::fromJson));
            } else if ("variables".equals(fieldName)) {
                recordedData.variables.addAll(reader.readArray(JsonReader::getString));
            } else {
                reader.skipChildren();
            }
        });
    }
}

