/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.test.TestMode;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.WriteValueCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class TestingHelpers {
    private static final ClientLogger LOGGER = new ClientLogger(TestingHelpers.class);
    public static final String AZURE_TEST_MODE = "AZURE_TEST_MODE";
    public static final HttpHeaderName X_RECORDING_ID = HttpHeaderName.fromString((String)"x-recording-id");
    public static final HttpHeaderName X_RECORDING_FILE_LOCATION = HttpHeaderName.fromString((String)"x-base64-recording-file-location");
    private static final TestMode TEST_MODE = TestingHelpers.initializeTestMode();

    private static TestMode initializeTestMode() {
        String azureTestMode = Configuration.getGlobalConfiguration().get(AZURE_TEST_MODE);
        if (azureTestMode != null) {
            try {
                return TestMode.valueOf(azureTestMode.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Could not parse '{}' into TestEnum. Using 'Playback' mode.", new Object[]{azureTestMode});
                return TestMode.PLAYBACK;
            }
        }
        LOGGER.info("Environment variable '{}' has not been set yet. Using 'Playback' mode.", new Object[]{AZURE_TEST_MODE});
        return TestMode.PLAYBACK;
    }

    public static TestMode getTestMode() {
        return TEST_MODE;
    }

    public static void copy(InputStream source, OutputStream destination) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = source.read(buffer, 0, buffer.length)) != -1) {
            destination.write(buffer, 0, read);
        }
    }

    public static String getTestName(Optional<Method> testMethod, String displayName, Optional<Class<?>> testClass) {
        String testName = "";
        String fullyQualifiedTestName = "";
        if (testMethod.isPresent()) {
            Method method = testMethod.get();
            String className = testClass.map(Class::getName).orElse(method.getDeclaringClass().getName());
            testName = method.getName();
            fullyQualifiedTestName = className + "." + testName;
        }
        return Objects.equals(displayName, testName) ? fullyQualifiedTestName : fullyQualifiedTestName + "(" + displayName + ")";
    }

    public static <T> T readObject(JsonReader jsonReader, Supplier<T> objectCreator, ReadObjectCallback<T> callback) throws IOException {
        return (T)jsonReader.readObject(reader -> {
            Object object = objectCreator.get();
            TestingHelpers.fieldReaderLoop(reader, (WriteValueCallback<String, JsonReader>)((WriteValueCallback)(fieldName, r) -> callback.read(object, (String)fieldName, (JsonReader)r)));
            return object;
        });
    }

    public static void fieldReaderLoop(JsonReader jsonReader, WriteValueCallback<String, JsonReader> fieldConsumer) throws IOException {
        while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jsonReader.getFieldName();
            jsonReader.nextToken();
            fieldConsumer.write((Object)fieldName, (Object)jsonReader);
        }
    }

    public static interface ReadObjectCallback<T> {
        public void read(T var1, String var2, JsonReader var3) throws IOException;
    }
}

