/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.TestBase;
import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.util.logging.ClientLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ThreadDumper
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final ClientLogger LOGGER = new ClientLogger(ThreadDumper.class);
    private static volatile ExecutorService executorService;
    private static final int INITIAL_DELAY_IN_MINUTES = 30;
    private static final int RATE_IN_MINUTES = 2;
    private static final long FIVE_MINUTES_MILLIS;
    private static final Map<String, Long> RUNNING_TEST_TIMES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize() {
        if (executorService != null) return;
        Class<ThreadDumper> clazz = ThreadDumper.class;
        synchronized (ThreadDumper.class) {
            if (executorService != null) return;
            executorService = ThreadDumper.createExecutorService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static ExecutorService createExecutorService() {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        Runtime.getRuntime().addShutdownHook(new Thread(service::shutdown));
        service.scheduleAtFixedRate(ThreadDumper::printThreadStacks, 30L, 2L, TimeUnit.MINUTES);
        return service;
    }

    private static void printThreadStacks() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder("============= THREAD DUMP START =========");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        dump.append("============= THREAD DUMP END =========").append(System.lineSeparator()).append("========= RUNNING TESTS START =========");
        long nowMillis = System.currentTimeMillis();
        for (Map.Entry<String, Long> runningTest : RUNNING_TEST_TIMES.entrySet()) {
            if (nowMillis - runningTest.getValue() <= FIVE_MINUTES_MILLIS) continue;
            dump.append(System.lineSeparator()).append(runningTest.getKey()).append(": ").append(nowMillis - runningTest.getValue()).append(" millis");
        }
        dump.append("========== RUNNING TESTS END ==========\n");
        String output = dump.toString();
        System.err.println(output);
        LOGGER.info(output);
    }

    public void beforeAll(ExtensionContext context) {
        ThreadDumper.initialize();
    }

    public void beforeEach(ExtensionContext context) {
        Class clazz = context.getTestClass().orElse(null);
        if (clazz != null && TestBase.class.isAssignableFrom(clazz)) {
            return;
        }
        RUNNING_TEST_TIMES.put(ThreadDumper.getFullTestName(context), System.currentTimeMillis());
    }

    static void addRunningTest(String testName) {
        RUNNING_TEST_TIMES.put(testName, System.currentTimeMillis());
    }

    public void afterEach(ExtensionContext context) {
        Class clazz = context.getTestClass().orElse(null);
        if (clazz != null && TestBase.class.isAssignableFrom(clazz)) {
            return;
        }
        RUNNING_TEST_TIMES.remove(ThreadDumper.getFullTestName(context));
    }

    static void removeRunningTest(String testName) {
        RUNNING_TEST_TIMES.remove(testName);
    }

    private static String getFullTestName(ExtensionContext context) {
        return TestingHelpers.getTestName(context.getTestMethod(), context.getDisplayName(), context.getTestClass());
    }

    static {
        FIVE_MINUTES_MILLIS = Duration.ofMinutes(5L).toMillis();
        RUNNING_TEST_TIMES = new ConcurrentHashMap<String, Long>();
    }
}

