/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.util;

import com.apifan.common.random.util.ResourceUtils;
import com.apifan.common.random.util.pinyin.PinyinConverter;
import com.apifan.common.random.util.pinyin.impl.Pinyin4jConverter;
import com.apifan.common.random.util.pinyin.impl.TinyPinyinConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinUtils {
    private static final Logger log = LoggerFactory.getLogger(PinyinUtils.class);
    private static final PinyinConverter pinyinConverter = PinyinUtils.getRealPinyinConverter();

    public static String toPinyin(String src, boolean toLowerCase) {
        return pinyinConverter.toPinyin(src, toLowerCase);
    }

    private static PinyinConverter getRealPinyinConverter() {
        if (ResourceUtils.isClassLoaded("com.github.promeg.pinyinhelper.Pinyin")) {
            log.info("\u5c06\u4f7f\u7528 tinypinyin");
            return new TinyPinyinConverter();
        }
        if (ResourceUtils.isClassLoaded("net.sourceforge.pinyin4j.PinyinHelper")) {
            log.info("\u5c06\u4f7f\u7528 pinyin4j");
            return new Pinyin4jConverter();
        }
        throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u62fc\u97f3\u5e93");
    }
}

