/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.util;

import com.apifan.common.random.util.ResourceUtils;
import com.apifan.common.random.util.json.JsonConverter;
import com.apifan.common.random.util.json.impl.FastjsonConverter;
import com.apifan.common.random.util.json.impl.GsonConverter;
import com.apifan.common.random.util.json.impl.JacksonConverter;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final JsonConverter jsonConverter = JsonUtils.getRealJsonConverter();

    public static String toJson(Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"\u5bf9\u8c61\u4e3a\u7a7a");
        return jsonConverter.toJson(obj);
    }

    public static <T> T parseObject(String text, Class<T> targetClass) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)text), (Object)"\u5f85\u89e3\u6790\u7684JSON\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        Preconditions.checkNotNull(targetClass, (Object)"\u76ee\u6807\u7c7b\u4e3a\u7a7a");
        return jsonConverter.parseObject(text, targetClass);
    }

    public static <T> List<T> parseObjectList(String text, Class<T> targetClass) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)text), (Object)"\u5f85\u89e3\u6790\u7684JSON\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        Preconditions.checkNotNull(targetClass, (Object)"\u76ee\u6807\u7c7b\u4e3a\u7a7a");
        return jsonConverter.parseObjectList(text, targetClass);
    }

    public static List<Map<String, Object>> parseMapList(String text) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)text), (Object)"\u5f85\u89e3\u6790\u7684JSON\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        return jsonConverter.parseMapList(text);
    }

    private static JsonConverter getRealJsonConverter() {
        if (ResourceUtils.isClassLoaded("com.fasterxml.jackson.databind.ObjectMapper")) {
            log.info("\u5c06\u4f7f\u7528 jackson");
            return new JacksonConverter();
        }
        if (ResourceUtils.isClassLoaded("com.alibaba.fastjson.JSON")) {
            log.info("\u5c06\u4f7f\u7528 fastjson");
            return new FastjsonConverter();
        }
        if (ResourceUtils.isClassLoaded("com.google.gson.Gson")) {
            log.info("\u5c06\u4f7f\u7528 gson");
            return new GsonConverter();
        }
        throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684JSON\u5e93");
    }
}

