/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.util;

import com.apifan.common.random.entity.DataField;
import com.apifan.common.random.util.JsonUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataUtils.class);

    public static String generateJson(List<DataField> fieldList, int total) {
        ArrayList<String> strList = new ArrayList<String>();
        for (int i = 0; i < total; ++i) {
            strList.add(DataUtils.generateJson(fieldList));
        }
        return "[" + Joiner.on((String)",").join(strList) + "]";
    }

    public static String generateSql(List<DataField> fieldList, String tableName, int total) {
        fieldList = DataUtils.skipInvalidFields(fieldList);
        ArrayList columnsList = new ArrayList();
        fieldList.forEach(f -> columnsList.add(f.getField()));
        ArrayList<String> dataList = new ArrayList<String>();
        for (int i = 0; i < total; ++i) {
            ArrayList paramsList = new ArrayList();
            fieldList.forEach(f -> {
                Object value = f.getValueSupplier().get();
                String valueStr = String.valueOf(value);
                boolean wrap = value instanceof String;
                paramsList.add(wrap ? StringUtils.wrap((String)valueStr, (String)"\"") : valueStr);
            });
            dataList.add("select " + Joiner.on((String)",").join(paramsList) + " from dual");
        }
        return "insert into " + tableName + "(" + Joiner.on((String)",").join(columnsList) + ")\n" + Joiner.on((String)"\nunion all\n").join(dataList);
    }

    public static String generateCsv(List<DataField> fieldList, int total) {
        fieldList = DataUtils.skipInvalidFields(fieldList);
        ArrayList columnsList = new ArrayList();
        fieldList.forEach(f -> columnsList.add(StringUtils.wrap((String)f.getField(), (String)"\"")));
        ArrayList<String> dataList = new ArrayList<String>();
        for (int i = 0; i < total; ++i) {
            ArrayList paramsList = new ArrayList();
            fieldList.forEach(f -> paramsList.add(StringUtils.wrap((String)String.valueOf(f.getValueSupplier().get()), (String)"\"")));
            dataList.add(Joiner.on((String)",").join(paramsList));
        }
        return Joiner.on((String)",").join(columnsList) + "\n" + Joiner.on((String)"\n").join(dataList);
    }

    public static <T> T generateObject(List<DataField> fieldList, Class<T> clazz) throws Exception {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
        return JsonUtils.parseObject(DataUtils.generateJson(fieldList), clazz);
    }

    public static <T> List<T> generateObjectList(List<DataField> fieldList, Class<T> clazz, int total) throws Exception {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
        Preconditions.checkArgument((total > 0 ? 1 : 0) != 0, (Object)"\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        ArrayList<T> resultList = new ArrayList<T>(total);
        for (int i = 0; i < total; ++i) {
            resultList.add(DataUtils.generateObject(fieldList, clazz));
        }
        return resultList;
    }

    private static List<DataField> skipInvalidFields(List<DataField> fieldList) {
        if (CollectionUtils.isEmpty(fieldList)) {
            throw new RuntimeException("\u6570\u636e\u5b57\u6bb5\u5b9a\u4e49\u4e3a\u7a7a!");
        }
        List<DataField> validList = fieldList.stream().filter(Objects::nonNull).filter(i -> StringUtils.isNotBlank((CharSequence)i.getField()) && i.getValueSupplier() != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(validList)) {
            throw new RuntimeException("\u6709\u6548\u7684\u6570\u636e\u5b57\u6bb5\u5b9a\u4e49\u4e3a\u7a7a!");
        }
        return validList;
    }

    private static String generateJson(List<DataField> fieldList) {
        fieldList = DataUtils.skipInvalidFields(fieldList);
        LinkedHashMap element = new LinkedHashMap();
        fieldList.forEach(f -> {
            if (f == null || StringUtils.isBlank((CharSequence)f.getField()) || f.getValueSupplier() == null) {
                return;
            }
            element.put(f.getField(), f.getValueSupplier().get());
        });
        try {
            return JsonUtils.toJson(element);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u6362JSON\u5b57\u7b26\u4e32\u65f6\u51fa\u9519", (Throwable)e);
            return null;
        }
    }
}

