package com.anji.plus.gaea.utils;

/**
 * 数据脱敏
 * @author lr
 * @since 2021-02-04
 */
public class GaeaMaskUtils {

    /**
     * 默认的脱敏规则
     */
    public static final String defaultPattern = "(\\w{1})\\w+(\\w{1})";

    /**
     * 数据脱敏
     * @param source
     * @param reg 正则表达式
     * @param replacement 替换表达式
     * @return
     */
    public static String mask(String source, String reg, String replacement) {
        return source.replaceAll(reg, replacement);
    }

}
