/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Location;
import com.android.zipflinger.NoCopyByteArrayOutputStream;
import com.android.zipflinger.PayloadInputStream;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipSource;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class ZipSourceEntryPipe
extends Source {
    private final ZipSource zipSource;
    private final int compressionLevel;
    private Entry entry;
    private ByteBuffer byteBuffer;

    ZipSourceEntryPipe(String newName, Entry entry, ZipSource zipSource, int compressionLevel) {
        super(newName);
        this.entry = entry;
        this.zipSource = zipSource;
        this.compressionLevel = compressionLevel;
    }

    @Override
    public void prepare() throws IOException {
        this.crc = this.entry.getCrc();
        this.compressionFlag = this.compressionLevel != 0 ? (short)8 : (short)0;
        this.uncompressedSize = this.entry.getUncompressedSize();
        FileChannel channel = this.zipSource.getChannel();
        Location loc = this.entry.getPayloadLocation();
        try (NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream(8192);
             PayloadInputStream in = new PayloadInputStream(channel, loc);){
            Compressor.pipe(in, out, this.entry.isCompressed(), this.compressionLevel);
            this.byteBuffer = out.getByteBuffer();
            this.compressedSize = this.byteBuffer.limit();
        }
    }

    @Override
    public long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.byteBuffer);
    }
}

