/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.sampledata;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class SampleDataJsonParser {
    private static final Logger LOG = Logger.getLogger(SampleDataJsonParser.class.getSimpleName());
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings().trimResults();
    private static final Joiner NEW_LINE_JOINER = Joiner.on((char)'\n');
    private final JsonObject myRootObject;

    private SampleDataJsonParser(JsonObject rootObject) {
        this.myRootObject = rootObject;
    }

    public static SampleDataJsonParser parse(Reader reader) {
        JsonParser parser = new JsonParser();
        try {
            return new SampleDataJsonParser(parser.parse(reader).getAsJsonObject());
        }
        catch (Throwable e) {
            LOG.throwing("SampleDataJsonParser", "parse", e);
            return null;
        }
    }

    public byte[] getContentFromPath(String path) {
        ImmutableList pathItems = ImmutableList.copyOf((Collection)PATH_SPLITTER.splitToList((CharSequence)path));
        ArrayList<String> content = new ArrayList<String>();
        SampleDataJsonParser.visitElementAndGetContent((JsonElement)this.myRootObject, (List<String>)pathItems, content);
        return NEW_LINE_JOINER.join(content).getBytes(Charsets.UTF_8);
    }

    public Set<String> getPossiblePaths() {
        HashSet<String> paths = new HashSet<String>();
        SampleDataJsonParser.visitElementAndGetPath((JsonElement)this.myRootObject, "", paths);
        return paths;
    }

    static void visitElementAndGetPath(JsonElement name, String pathSoFar, Set<String> pathOut) {
        if (name == null) {
            return;
        }
        if (name.isJsonPrimitive()) {
            pathOut.add(pathSoFar);
        } else if (name.isJsonArray()) {
            JsonArray array = name.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                SampleDataJsonParser.visitElementAndGetPath(array.get(i), pathSoFar, pathOut);
            }
        } else if (name.isJsonObject()) {
            JsonObject object = name.getAsJsonObject();
            object.entrySet().forEach(entry -> SampleDataJsonParser.visitElementAndGetPath((JsonElement)entry.getValue(), pathSoFar + "/" + (String)entry.getKey(), pathOut));
        }
    }

    static void visitElementAndGetContent(JsonElement name, List<String> path, List<String> contentOut) {
        if (name == null) {
            return;
        }
        if (path.isEmpty()) {
            contentOut.add(name.getAsString());
            return;
        }
        if (name.isJsonArray()) {
            JsonArray array = name.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                SampleDataJsonParser.visitElementAndGetContent(array.get(i), path, contentOut);
            }
        } else if (name.isJsonObject()) {
            JsonObject object = name.getAsJsonObject();
            String pathItem = path.get(0);
            SampleDataJsonParser.visitElementAndGetContent(object.get(pathItem), path.subList(1, path.size()), contentOut);
        }
    }
}

