/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CountryCodeQualifier
extends ResourceQualifier {
    private static final int DEFAULT_CODE = -1;
    private static final Pattern sCountryCodePattern = Pattern.compile("^mcc(\\d{3})$");
    private final int mCode;
    public static final String NAME = "Mobile Country Code";

    public static CountryCodeQualifier getQualifier(String segment) {
        Matcher m = sCountryCodePattern.matcher(segment);
        if (m.matches()) {
            int code;
            String v = m.group(1);
            try {
                code = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return null;
            }
            CountryCodeQualifier qualifier = new CountryCodeQualifier(code);
            return qualifier;
        }
        return null;
    }

    public static String getFolderSegment(int code) {
        if (code != -1 && code >= 100 && code <= 999) {
            return String.format("mcc%1$d", code);
        }
        return "";
    }

    public CountryCodeQualifier() {
        this(-1);
    }

    public CountryCodeQualifier(int code) {
        this.mCode = code;
    }

    public int getCode() {
        return this.mCode;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return "Country Code";
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.mCode != -1;
    }

    @Override
    public boolean hasFakeValue() {
        return false;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        CountryCodeQualifier qualifier = CountryCodeQualifier.getQualifier(value);
        if (qualifier != null) {
            config.setCountryCodeQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object qualifier) {
        if (qualifier instanceof CountryCodeQualifier) {
            return this.mCode == ((CountryCodeQualifier)qualifier).mCode;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mCode;
    }

    @Override
    public String getFolderSegment() {
        return CountryCodeQualifier.getFolderSegment(this.mCode);
    }

    @Override
    public String getShortDisplayValue() {
        if (this.mCode != -1) {
            return String.format("MCC %1$d", this.mCode);
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        return this.getShortDisplayValue();
    }
}

