/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontsFolderProvider;
import com.android.ide.common.fonts.SdkFonts;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/android/ide/common/fonts/SdkFontsFolderProvider;", "Lcom/android/ide/common/fonts/FontsFolderProvider;", "sdkHomeProvider", "Ljava/util/function/Supplier;", "Ljava/io/File;", "<init>", "(Ljava/util/function/Supplier;)V", "cachedSdkHome", "fontsFolder", "getFontsFolder", "()Ljava/io/File;", "createTempSdk", "sdk-common"})
public final class SdkFontsFolderProvider
implements FontsFolderProvider {
    @NotNull
    private final Supplier<File> sdkHomeProvider;
    @Nullable
    private File cachedSdkHome;

    public SdkFontsFolderProvider(@NotNull Supplier<File> sdkHomeProvider) {
        Intrinsics.checkNotNullParameter(sdkHomeProvider, (String)"sdkHomeProvider");
        this.sdkHomeProvider = sdkHomeProvider;
    }

    @Override
    @Nullable
    public File getFontsFolder() {
        File sdkHome = this.sdkHomeProvider.get();
        if (sdkHome == null) {
            File file = this.cachedSdkHome;
            if (file == null) {
                file = this.createTempSdk();
            }
            this.cachedSdkHome = sdkHome = file;
        }
        return SdkFonts.getFontsPath(sdkHome);
    }

    private final File createTempSdk() {
        File file;
        try {
            file = Files.createTempDirectory("tempSdk", new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            file = null;
        }
        return file;
    }
}

