/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0011B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0012B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0013B\t\b\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u0016\u00101\u001a\u0004\u0018\u0001022\f\u00103\u001a\b\u0012\u0004\u0012\u00020204J\u000e\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000202R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\"\"\u0004\b&\u0010$R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0016\"\u0004\b,\u0010\u0018R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0016\"\u0004\b.\u0010\u0018R\u001a\u0010\u000f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010(\"\u0004\b0\u0010*\u00a8\u00067"}, d2={"Lcom/android/ide/common/fonts/MutableFontDetail;", "", "name", "", "type", "Lcom/android/ide/common/fonts/FontType;", "weight", "", "width", "", "italics", "exact", "", "fontUrl", "styleName", "hasExplicitStyle", "<init>", "(Ljava/lang/String;Lcom/android/ide/common/fonts/FontType;IFFZLjava/lang/String;Ljava/lang/String;Z)V", "(Ljava/lang/String;IFFZ)V", "(Ljava/lang/String;Lcom/android/ide/common/fonts/FontType;FZ)V", "()V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getType", "()Lcom/android/ide/common/fonts/FontType;", "setType", "(Lcom/android/ide/common/fonts/FontType;)V", "getWeight", "()I", "setWeight", "(I)V", "getWidth", "()F", "setWidth", "(F)V", "getItalics", "setItalics", "getExact", "()Z", "setExact", "(Z)V", "getFontUrl", "setFontUrl", "getStyleName", "setStyleName", "getHasExplicitStyle", "setHasExplicitStyle", "findBestMatch", "Lcom/android/ide/common/fonts/FontDetail;", "fonts", "", "match", "other", "sdk-common"})
public final class MutableFontDetail {
    @NotNull
    private String name;
    @NotNull
    private FontType type;
    private int weight;
    private float width;
    private float italics;
    private boolean exact;
    @NotNull
    private String fontUrl;
    @NotNull
    private String styleName;
    private boolean hasExplicitStyle;

    public MutableFontDetail(@NotNull String name, @NotNull FontType type, int weight, float width, float italics, boolean exact, @NotNull String fontUrl, @NotNull String styleName, boolean hasExplicitStyle) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)fontUrl, (String)"fontUrl");
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        this.name = name;
        this.type = type;
        this.weight = weight;
        this.width = width;
        this.italics = italics;
        this.exact = exact;
        this.fontUrl = fontUrl;
        this.styleName = styleName;
        this.hasExplicitStyle = hasExplicitStyle;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final FontType getType() {
        return this.type;
    }

    public final void setType(@NotNull FontType fontType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fontType), (String)"<set-?>");
        this.type = fontType;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final void setWeight(int n) {
        this.weight = n;
    }

    public final float getWidth() {
        return this.width;
    }

    public final void setWidth(float f) {
        this.width = f;
    }

    public final float getItalics() {
        return this.italics;
    }

    public final void setItalics(float f) {
        this.italics = f;
    }

    public final boolean getExact() {
        return this.exact;
    }

    public final void setExact(boolean bl) {
        this.exact = bl;
    }

    @NotNull
    public final String getFontUrl() {
        return this.fontUrl;
    }

    public final void setFontUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fontUrl = string;
    }

    @NotNull
    public final String getStyleName() {
        return this.styleName;
    }

    public final void setStyleName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.styleName = string;
    }

    public final boolean getHasExplicitStyle() {
        return this.hasExplicitStyle;
    }

    public final void setHasExplicitStyle(boolean bl) {
        this.hasExplicitStyle = bl;
    }

    public MutableFontDetail(@NotNull String name, int weight, float width, float italics, boolean exact) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, FontType.SINGLE, weight, width, italics, exact, "", "", false);
    }

    public MutableFontDetail(@NotNull String name, @NotNull FontType type, float italics, boolean exact) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(name, type, 400, 100.0f, italics, exact, "", "", false);
    }

    public MutableFontDetail() {
        this("", FontType.SINGLE, 0.0f, true);
    }

    @Nullable
    public final FontDetail findBestMatch(@NotNull Collection<FontDetail> fonts) {
        Intrinsics.checkNotNullParameter(fonts, (String)"fonts");
        FontDetail best = null;
        float bestMatch = Float.MAX_VALUE;
        for (FontDetail detail : fonts) {
            float match2 = this.match(detail);
            if (!(match2 < bestMatch)) continue;
            bestMatch = match2;
            best = detail;
            if (!(match2 == 0.0f)) continue;
            break;
        }
        return best;
    }

    public final float match(@NotNull FontDetail other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (float)Math.abs(this.weight - other.getWeight()) + Math.abs(this.width - other.getWidth()) + Math.abs(this.italics - other.getItalics()) * 50.0f + (this.type != other.getType() ? 500.0f : 0.0f);
    }
}

