/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SkippingWarning1Parser
extends AbstractAaptOutputParser {
    private static final Pattern MSG_PATTERN = Pattern.compile("    \\(skipping (.+) .+ '(.*)'\\)");

    SkippingWarning1Parser() {
    }

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        Matcher m = MSG_PATTERN.matcher(line);
        if (!m.matches()) {
            return false;
        }
        String sourcePath2 = m.group(2);
        String type = m.group(1);
        if (type.equals("backup") || type.equals("hidden") || type.equals("index")) {
            return true;
        }
        Message msg = SkippingWarning1Parser.createMessage(Message.Kind.WARNING, line, sourcePath2, null, "", logger);
        messages.add(msg);
        return true;
    }
}

