/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistrationDetector
extends LayoutDetector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"Registered", (String)"Class is not registered in the manifest", (String)"Activities, services and content providers should be registered in the `AndroidManifest.xml` file using `<activity>`, `<service>` and `<provider>` tags.\n\nIf your activity is simply a parent class intended to be subclassed by other \"real\" activities, make it an abstract class.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(RegistrationDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/topics/manifest/manifest-intro.html").setAndroidSpecific(true).setEnabledByDefault(false);
    protected Map<String, String> mManifestRegistrations;
    private static final String KEY_LOCATION = "location";
    private static final String KEY_ID = "id";
    private static final String[] sTags = new String[]{"activity", "service", "receiver", "provider", "application"};
    private static final String[] sClasses = new String[]{"android.app.Activity", "android.app.Service", "android.content.BroadcastReceiver", "android.content.ContentProvider", "android.app.Application"};

    private Map<String, String> getManifestRegistrations(Project mainProject) {
        if (this.mManifestRegistrations == null) {
            Document mergedManifest = mainProject.getMergedManifest();
            if (mergedManifest == null || mergedManifest.getDocumentElement() == null) {
                return null;
            }
            this.mManifestRegistrations = Maps.newHashMap();
            Element application = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application");
            if (application != null) {
                this.registerElement(application);
                for (Element c : XmlUtils.getSubTags((Node)application)) {
                    this.registerElement(c);
                }
            }
        }
        return this.mManifestRegistrations;
    }

    private void registerElement(Element c) {
        String fqcn = Lint.resolveManifestName((Element)c);
        String tag = c.getTagName();
        String frameworkClass = RegistrationDetector.tagToClass(tag);
        if (frameworkClass != null) {
            this.mManifestRegistrations.put(fqcn, frameworkClass);
            if (fqcn.indexOf(36) != -1) {
                fqcn = fqcn.replace('$', '.');
                this.mManifestRegistrations.put(fqcn, frameworkClass);
            }
        }
    }

    public List<String> applicableSuperClasses() {
        return Arrays.asList("android.content.ComponentCallbacks2", "android.content.BroadcastReceiver");
    }

    public void visitClass(JavaContext context, UClass cls) {
        String framework;
        if (context.getProject().isLibrary()) {
            return;
        }
        if (context.isTestSource()) {
            return;
        }
        if (cls.getName() == null) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)cls) || evaluator.isPrivate((PsiModifierListOwner)cls)) {
            return;
        }
        String rightTag = RegistrationDetector.getTag(evaluator, cls);
        if (rightTag == null) {
            return;
        }
        if (rightTag.equals("receiver")) {
            return;
        }
        String className = cls.getQualifiedName();
        if (className == null) {
            return;
        }
        if (!context.isGlobalAnalysis()) {
            if (!context.getDriver().isSuppressed(context, ISSUE, (UElement)cls)) {
                LintMap map = new LintMap();
                map.put(KEY_LOCATION, context.getNameLocation(cls));
                map.put(KEY_ID, rightTag);
                context.getPartialResults(ISSUE).map().put(className, map);
            }
            return;
        }
        Map<String, String> manifestRegistrations = this.getManifestRegistrations(context.getMainProject());
        if (manifestRegistrations != null && (framework = manifestRegistrations.get(className)) == null) {
            Location location = context.getNameLocation(cls);
            String message2 = RegistrationDetector.getMissingMessage(className, rightTag);
            context.report(ISSUE, cls, location, message2);
        }
    }

    public void checkPartialResults(Context context, PartialResult partialResults) {
        Map<String, String> manifestRegistrations = this.getManifestRegistrations(context.getMainProject());
        if (manifestRegistrations != null) {
            for (LintMap map : partialResults.maps()) {
                for (String className : map) {
                    LintMap m;
                    String framework = manifestRegistrations.get(className);
                    if (framework != null || (m = map.getMap(className)) == null) continue;
                    Location location = m.getLocation(KEY_LOCATION);
                    String rightTag = m.getString(KEY_ID, null);
                    if (location == null || rightTag == null) continue;
                    String message2 = RegistrationDetector.getMissingMessage(className, rightTag);
                    context.report(new Incident(ISSUE, location, message2));
                }
            }
        }
    }

    private static String getMissingMessage(String className, String tag) {
        return String.format("The `<%1$s> %2$s` is not registered in the manifest", tag, className);
    }

    private static String getTag(JavaEvaluator evaluator, UClass cls) {
        String tag = null;
        for (String s : sClasses) {
            if (!evaluator.extendsClass((PsiClass)cls, s, false)) continue;
            tag = RegistrationDetector.classToTag(s);
            break;
        }
        return tag;
    }

    private static String tagToClass(String tag) {
        int n = sTags.length;
        for (int i = 0; i < n; ++i) {
            if (!sTags[i].equals(tag)) continue;
            return sClasses[i];
        }
        return null;
    }

    protected static String classToTag(String className) {
        int n = sClasses.length;
        for (int i = 0; i < n; ++i) {
            if (!sClasses[i].equals(className)) continue;
            return sTags[i];
        }
        return null;
    }
}

