/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/KotlinNullnessAnnotationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "findKotlinTypeAnnotation", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "findKotlinTypeString", "inheritAnnotation", "", "annotation", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "locationWithNextSpace", "Lcom/android/tools/lint/detector/api/Location;", "location", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "visitAnnotationUsage", "", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nKotlinNullnessAnnotationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNullnessAnnotationDetector.kt\ncom/android/tools/lint/checks/KotlinNullnessAnnotationDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,240:1\n766#2:241\n857#2,2:242\n1603#2,9:244\n1855#2:253\n1856#2:255\n1612#2:256\n288#2,2:257\n288#2,2:272\n1#3:254\n1#3:269\n11383#4,9:259\n13309#4:268\n13310#4:270\n11392#4:271\n*S KotlinDebug\n*F\n+ 1 KotlinNullnessAnnotationDetector.kt\ncom/android/tools/lint/checks/KotlinNullnessAnnotationDetector\n*L\n195#1:241\n195#1:242,2\n196#1:244,9\n196#1:253\n196#1:255\n196#1:256\n197#1:257,2\n206#1:272,2\n196#1:254\n205#1:269\n205#1:259,9\n205#1:268\n205#1:270\n205#1:271\n*E\n"})
public final class KotlinNullnessAnnotationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(KotlinNullnessAnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String IDEA_NULLABLE = "org.jetbrains.annotations.Nullable";
    @NotNull
    public static final String IDEA_NOTNULL = "org.jetbrains.annotations.NotNull";

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{"Nullable", "NonNull", "NotNull", "Nonnull"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type == AnnotationUsageType.DEFINITION;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Incident incident;
        boolean bl;
        boolean isNullable;
        boolean annotationContradictsKotlinType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (element.getSourcePsi() == null) {
            return;
        }
        if (!Lint.isKotlin((Language)element.getLang())) {
            return;
        }
        UElement uElement = element.getUastParent();
        UAnnotated uAnnotated = uElement instanceof UAnnotated ? (UAnnotated)uElement : null;
        if (uAnnotated == null) {
            return;
        }
        UAnnotated annotated = uAnnotated;
        String string = this.findKotlinTypeAnnotation(annotated, annotationInfo);
        if (string == null) {
            return;
        }
        String actualTypeAnnotation = string;
        String annotationName = StringsKt.substringAfterLast((String)annotationInfo.getQualifiedName(), (char)'.', (String)annotationInfo.getQualifiedName());
        boolean declaredNullable = StringsKt.endsWith$default((String)annotationName, (String)"Nullable", (boolean)false, (int)2, null);
        boolean bl2 = annotationContradictsKotlinType = declaredNullable != (isNullable = Intrinsics.areEqual((Object)actualTypeAnnotation, (Object)"Nullable"));
        if (!annotationContradictsKotlinType && StringsKt.startsWith$default((String)annotationInfo.getQualifiedName(), (String)"javax.annotation", (boolean)false, (int)2, null)) {
            return;
        }
        StringBuilder $this$visitAnnotationUsage_u24lambda_u240 = new StringBuilder("Do not use `@" + annotationName + "` in Kotlin; ");
        boolean bl3 = false;
        String typeString2 = this.findKotlinTypeString(annotated);
        if (annotationContradictsKotlinType) {
            $this$visitAnnotationUsage_u24lambda_u240.append("the nullability is determined by the Kotlin type ");
            if (typeString2 != null) {
                $this$visitAnnotationUsage_u24lambda_u240.append("`").append(typeString2).append("` ");
                boolean bl4 = bl = isNullable == StringsKt.endsWith$default((String)typeString2, (String)"?", (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
            }
            if (isNullable) {
                $this$visitAnnotationUsage_u24lambda_u240.append("ending with `?` which declares it nullable");
            } else {
                $this$visitAnnotationUsage_u24lambda_u240.append("**not** ending with `?` which declares it not nullable");
            }
            $this$visitAnnotationUsage_u24lambda_u240.append(", contradicting the annotation");
        } else {
            $this$visitAnnotationUsage_u24lambda_u240.append("the nullability is already implied by the Kotlin type ");
            if (typeString2 != null) {
                $this$visitAnnotationUsage_u24lambda_u240.append("`").append(typeString2).append("` ");
                boolean bl5 = bl = isNullable == StringsKt.endsWith$default((String)typeString2, (String)"?", (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
            }
            if (declaredNullable) {
                $this$visitAnnotationUsage_u24lambda_u240.append("ending with `?`");
            } else {
                $this$visitAnnotationUsage_u24lambda_u240.append("**not** ending with `?`");
            }
        }
        String string4 = $this$visitAnnotationUsage_u24lambda_u240.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"with(StringBuilder(\"Do n\u2026       toString()\n      }");
        String message2 = string4;
        Location location = context.getLocation(element);
        Location fixLocation = this.locationWithNextSpace(location, context, element);
        LintFix fix = this.fix().replace().name("Delete `@" + annotationName + "`").all().with("").range(fixLocation).build();
        Incident $this$visitAnnotationUsage_u24lambda_u241 = incident = new Incident(ISSUE, (Object)element, location, message2, fix);
        boolean bl6 = false;
        if (!annotationContradictsKotlinType) {
            $this$visitAnnotationUsage_u24lambda_u241.overrideSeverity(Severity.WARNING);
            fix.autoFix();
        }
        Incident incident2 = incident;
        context.report(incident2);
    }

    private final String findKotlinTypeString(UAnnotated annotated) {
        PsiElement sourcePsi = annotated.getSourcePsi();
        Object typeReference = sourcePsi instanceof KtParameter ? ((KtParameter)sourcePsi).getTypeReference() : (sourcePsi instanceof KtProperty ? ((KtProperty)sourcePsi).getTypeReference() : (sourcePsi instanceof KtNamedFunction ? ((KtNamedFunction)sourcePsi).getTypeReference() : null));
        Object object = typeReference;
        return object != null && (object = object.getText()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final String findKotlinTypeAnnotation(UAnnotated annotated, AnnotationInfo annotationInfo) {
        String kotlinNullnessAnnotation;
        String string;
        Object v0;
        block8: {
            void $this$firstOrNull$iv;
            Iterator $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List directAnnotations = annotated.getUAnnotations();
            Iterable iterable = directAnnotations;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UAnnotation)element$iv$iv;
                boolean bl = false;
                if (!(it != annotationInfo.getAnnotation())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl = false;
                UAnnotation it2 = (UAnnotation)element$iv$iv;
                boolean bl2 = false;
                if (it2.getQualifiedName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String qualifiedName = (String)element$iv;
                boolean bl4 = false;
                if (!(Intrinsics.areEqual((Object)qualifiedName, (Object)IDEA_NOTNULL) || Intrinsics.areEqual((Object)qualifiedName, (Object)IDEA_NULLABLE))) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        if ((string = (String)v0) == null) {
            KotlinNullnessAnnotationDetector $this$findKotlinTypeAnnotation_u24lambda_u247 = this;
            boolean bl = false;
            if (annotated instanceof UMethod) {
                Object v3;
                block9: {
                    void $this$firstOrNull$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object element$iv;
                    PsiAnnotation[] psiAnnotationArray = ((UMethod)annotated).getAnnotations();
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"annotated.annotations");
                    element$iv = psiAnnotationArray;
                    boolean $i$f$mapNotNull = false;
                    void bl4 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        String it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                        boolean bl5 = false;
                        PsiAnnotation it = (PsiAnnotation)element$iv$iv;
                        boolean bl6 = false;
                        if (it.getQualifiedName() == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        String qualifiedName = (String)element$iv2;
                        boolean bl8 = false;
                        if (!(Intrinsics.areEqual((Object)qualifiedName, (Object)IDEA_NOTNULL) || Intrinsics.areEqual((Object)qualifiedName, (Object)IDEA_NULLABLE))) continue;
                        v3 = element$iv2;
                        break block9;
                    }
                    v3 = null;
                }
                string = v3;
            } else {
                string = null;
            }
        }
        String string2 = kotlinNullnessAnnotation = string;
        return string2 != null ? StringsKt.substringAfterLast((String)string2, (char)'.', (String)kotlinNullnessAnnotation) : null;
    }

    private final Location locationWithNextSpace(Location location, JavaContext context, UElement element) {
        char nextChar;
        Location fixLocation = location;
        CharSequence doc = context.getContents();
        Position end = location.getEnd();
        if (doc != null && end != null && end.getOffset() < doc.length() && CharsKt.isWhitespace((char)(nextChar = doc.charAt(end.getOffset()))) && nextChar != '\n') {
            fixLocation = context.getRangeLocation(element, 0, element, 1);
        }
        return fixLocation;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"KotlinNullnessAnnotation", (String)"Kotlin nullability annotation", (String)"\n                In Kotlin, nullness is part of the type system; `s: String` is **never** null \\\n                and `s: String?` is sometimes null, whether or not you add in additional annotations \\\n                stating `@NonNull` or `@Nullable`. These are likely copy/paste mistakes, and are \\\n                misleading.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)true, (Boolean)true, null, null, (int)3088, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/KotlinNullnessAnnotationDetector$Issues;", "", "()V", "IDEA_NOTNULL", "", "IDEA_NULLABLE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

