/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\rH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/ForegroundServicePermissionDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkPermission", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "type", "", "allPermissions", "", "anyPermission", "getApplicableElements", "", "hasForegroundServicePermission", "", "visitElement", "Companion", "lint-checks"})
public final class ForegroundServicePermissionDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @NotNull
    private static final Issue ISSUE_PERMISSION;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"service");
    }

    private final boolean hasForegroundServicePermission(Element element) {
        Element element2 = element;
        Object object = element2 != null ? element2.getParentNode() : null;
        Element element3 = object instanceof Element ? (Element)object : null;
        if (element3 == null) {
            return false;
        }
        Element applicationTag = element3;
        Node node = applicationTag.getParentNode();
        Element element4 = node instanceof Element ? (Element)node : null;
        if (element4 == null) {
            return false;
        }
        Element manifestTag = element4;
        object = DomExtensions.subtags((Element)manifestTag, (String)"uses-permission");
        while (object.hasNext()) {
            String name;
            Element usesPermissionTag = (Element)object.next();
            if (usesPermissionTag.getAttributeNS("http://schemas.android.com/apk/res/android", "name") == null || !Intrinsics.areEqual((Object)"android.permission.FOREGROUND_SERVICE", (Object)name)) continue;
            return true;
        }
        return false;
    }

    private final void checkPermission(XmlContext context, Element element, String type, List<String> allPermissions, List<String> anyPermission) {
        ArrayList wantAllPermissions = new ArrayList(allPermissions);
        boolean hasAnyPermission = anyPermission == null;
        Element element2 = element;
        Object object = element2 != null ? element2.getParentNode() : null;
        Element element3 = object instanceof Element ? (Element)object : null;
        if (element3 == null) {
            return;
        }
        Element applicationTag = element3;
        Node node = applicationTag.getParentNode();
        Element element4 = node instanceof Element ? (Element)node : null;
        if (element4 == null) {
            return;
        }
        Element manifestTag = element4;
        object = DomExtensions.subtags((Element)manifestTag, (String)"uses-permission");
        while (object.hasNext()) {
            String name;
            Element usesPermissionTag = (Element)object.next();
            if (usesPermissionTag.getAttributeNS("http://schemas.android.com/apk/res/android", "name") == null) continue;
            if (wantAllPermissions.contains(name)) {
                wantAllPermissions.remove(name);
                continue;
            }
            if (anyPermission == null || !anyPermission.contains(name)) continue;
            hasAnyPermission = true;
        }
        boolean hasAllPermissions = wantAllPermissions.isEmpty();
        if (!hasAllPermissions || !hasAnyPermission) {
            List<String> list = anyPermission;
            String message2 = "foregroundServiceType:" + type + " requires permission:" + allPermissions + (String)(list == null ? "" : " AND any permission in list:" + list);
            Incident incident = new Incident(ISSUE_PERMISSION, (Object)element, context.getLocation((Node)element), message2);
            context.report(incident, Constraints.targetSdkAtLeast((int)34));
        }
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getTagName(), (Object)"service")) {
            return;
        }
        if (!this.hasForegroundServicePermission(element)) {
            return;
        }
        String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "foregroundServiceType");
        if (string == null) {
            return;
        }
        String types = string;
        char[] cArray = new char[]{'|'};
        Iterator iterator = StringsKt.split$default((CharSequence)types, (char[])cArray, (boolean)false, (int)0, (int)6, null).iterator();
        block30: while (iterator.hasNext()) {
            String type;
            switch (type = (String)iterator.next()) {
                case "dataSync": {
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_DATA_SYNC"), null);
                    continue block30;
                }
                case "mediaPlayback": {
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_MEDIA_PLAYBACK"), null);
                    continue block30;
                }
                case "phoneCall": {
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_PHONE_CALL"), CollectionsKt.listOf((Object)"android.permission.MANAGE_OWN_CALLS"));
                    continue block30;
                }
                case "location": {
                    Object[] objectArray = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_LOCATION"), CollectionsKt.listOf((Object[])objectArray));
                    continue block30;
                }
                case "connectedDevice": {
                    Object[] objectArray = new String[]{"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_SCAN", "android.permission.CHANGE_NETWORK_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.CHANGE_WIFI_MULTICAST_STATE", "android.permission.NFC", "android.permission.TRANSMIT_IR", "android.permission.UWB_RANGING"};
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_CONNECTED_DEVICE"), CollectionsKt.listOf((Object[])objectArray));
                    continue block30;
                }
                case "mediaProjection": {
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_MEDIA_PROJECTION"), null);
                    continue block30;
                }
                case "camera": {
                    Object[] objectArray = new String[]{"android.permission.CAMERA", "android.permission.SYSTEM_CAMERA"};
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_CAMERA"), CollectionsKt.listOf((Object[])objectArray));
                    continue block30;
                }
                case "microphone": {
                    Object[] objectArray = new String[]{"android.permission.CAPTURE_AUDIO_HOTWORD", "android.permission.CAPTURE_AUDIO_OUTPUT", "android.permission.CAPTURE_MEDIA_OUTPUT", "android.permission.CAPTURE_TUNER_AUDIO_INPUT", "android.permission.CAPTURE_VOICE_COMMUNICATION_OUTPUT", "android.permission.RECORD_AUDIO"};
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_MICROPHONE"), CollectionsKt.listOf((Object[])objectArray));
                    continue block30;
                }
                case "health": {
                    Object[] objectArray = new String[]{"android.permission.ACTIVITY_RECOGNITION", "android.permission.BODY_SENSORS", "android.permission.HIGH_SAMPLING_RATE_SENSORS"};
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_HEALTH"), CollectionsKt.listOf((Object[])objectArray));
                    continue block30;
                }
                case "remoteMessaging": {
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_REMOTE_MESSAGING"), null);
                    continue block30;
                }
                case "systemExempted": {
                    Object[] objectArray = new String[]{"android.permission.SCHEDULE_EXACT_ALARM", "android.permission.USE_EXACT_ALARM"};
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_SYSTEM_EXEMPTED"), CollectionsKt.listOf((Object[])objectArray));
                    continue block30;
                }
                case "fileManagement": {
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_FILE_MANAGEMENT"), null);
                    continue block30;
                }
                case "specialUse": {
                    this.checkPermission(context, element, type, CollectionsKt.listOf((Object)"android.permission.FOREGROUND_SERVICE_SPECIAL_USE"), null);
                    continue block30;
                }
            }
        }
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(ForegroundServicePermissionDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        ISSUE_PERMISSION = Issue.Companion.create("ForegroundServicePermission", "Missing permissions required by foregroundServiceType", "\n                For targetSdkVersion >= 34, each `foregroundServiceType` listed in the `<service>` element \\\n                requires specific sets of permissions to be declared in the manifest. If permissions are \\\n                missing, then when the foreground service is started with a `foregroundServiceType` that has \\\n                missing permissions, a `SecurityException` will be thrown.\n          ", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/ForegroundServicePermissionDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_PERMISSION", "()Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        @NotNull
        public final Issue getISSUE_PERMISSION() {
            return ISSUE_PERMISSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

