/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\"\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u0006*\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u001a\u001c\u0010\u0012\u001a\u00020\u0006*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u0016\u001a\u00020\u0006*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0019\u00a8\u0006\u001a"}, d2={"callName", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getOperatorText", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isSameComparison", "", "expectedOperator", "expectedValue", "methodName", "isInClass", "Lcom/intellij/psi/PsiMethod;", "name", "lineEnd", "", "", "start", "lineBegin", "isNotBlankAt", "end", "equalsIgnoringSpace", "other", "containsIdentifier", "identifier", "skipParenthesizedExprDown", "Lorg/jetbrains/kotlin/psi/KtExpression;", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nUseKtxDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseKtxDetector.kt\ncom/android/tools/lint/checks/UseKtxDetectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2522:1\n1#2:2523\n1761#3,3:2524\n*S KotlinDebug\n*F\n+ 1 UseKtxDetector.kt\ncom/android/tools/lint/checks/UseKtxDetectorKt\n*L\n2471#1:2524,3\n*E\n"})
public final class UseKtxDetectorKt {
    @NotNull
    public static final String callName(@NotNull KtCallExpression $this$callName) {
        Intrinsics.checkNotNullParameter((Object)$this$callName, (String)"<this>");
        Object object = $this$callName.getCalleeExpression();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final String getOperatorText(@NotNull KtBinaryExpression $this$getOperatorText) {
        Intrinsics.checkNotNullParameter((Object)$this$getOperatorText, (String)"<this>");
        IElementType iElementType = $this$getOperatorText.getOperationToken();
        Object object = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
        if (object == null || (object = object.getValue()) == null) {
            String string = $this$getOperatorText.getOperationToken().toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        }
        return object;
    }

    public static final boolean isSameComparison(@NotNull KtBinaryExpression $this$isSameComparison, @NotNull String expectedOperator, @NotNull String expectedValue, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isSameComparison, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedOperator, (String)"expectedOperator");
        Intrinsics.checkNotNullParameter((Object)expectedValue, (String)"expectedValue");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Object object = $this$isSameComparison.getRight();
        if (object == null || (object = object.getText()) == null) {
            return false;
        }
        Object value = object;
        String operator = UseKtxDetectorKt.getOperatorText($this$isSameComparison);
        if (Intrinsics.areEqual((Object)operator, (Object)expectedOperator)) {
            if (UseKtxDetectorKt.equalsIgnoringSpace((String)value, expectedValue)) {
                return true;
            }
            if (StringsKt.endsWith$default((String)expectedValue, (String)value, (boolean)false, (int)2, null) && expectedValue.charAt(expectedValue.length() - ((String)value).length() - 1) == '.') {
                return true;
            }
            int lastDot = StringsKt.lastIndexOf$default((CharSequence)expectedValue, (char)'.', (int)0, (boolean)false, (int)6, null);
            int nameLength = expectedValue.length() - (lastDot + 1);
            if (lastDot != -1 && expectedValue.length() - nameLength > 0 && StringsKt.regionMatches$default((String)expectedValue, (int)(expectedValue.length() - nameLength), (String)value, (int)(((String)value).length() - nameLength), (int)nameLength, (boolean)false, (int)16, null)) {
                PsiElement resolved;
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)$this$isSameComparison.getRight()));
                Object object2 = resolved = uElement != null ? UastUtils.tryResolve((UElement)uElement) : null;
                if (resolved instanceof PsiField) {
                    PsiClass psiClass = ((PsiField)resolved).getContainingClass();
                    String resolvedQualifiedName = (psiClass != null ? psiClass.getQualifiedName() : null) + "." + ((PsiField)resolved).getName();
                    if (Intrinsics.areEqual((Object)resolvedQualifiedName, (Object)expectedValue)) {
                        return true;
                    }
                }
            }
        }
        if ((StringsKt.contains((CharSequence)methodName, (CharSequence)"size", (boolean)true) || StringsKt.contains((CharSequence)methodName, (CharSequence)"count", (boolean)true)) && Intrinsics.areEqual((Object)expectedOperator, (Object)"!=") && Intrinsics.areEqual((Object)expectedValue, (Object)"0") && Intrinsics.areEqual((Object)operator, (Object)">") && Intrinsics.areEqual((Object)value, (Object)"0")) {
            return true;
        }
        return StringsKt.startsWith$default((String)methodName, (String)"index", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)expectedOperator, (Object)">=") && Intrinsics.areEqual((Object)expectedValue, (Object)"0") && Intrinsics.areEqual((Object)operator, (Object)"!=") && UseKtxDetectorKt.equalsIgnoringSpace((String)value, "-1") || Intrinsics.areEqual((Object)expectedOperator, (Object)"!=") && Intrinsics.areEqual((Object)expectedValue, (Object)"-1") && Intrinsics.areEqual((Object)operator, (Object)">=") && Intrinsics.areEqual((Object)value, (Object)"0");
    }

    public static final boolean isInClass(@Nullable PsiMethod $this$isInClass, @Nullable String name) {
        if ($this$isInClass == null) {
            return false;
        }
        if (name == null) {
            return false;
        }
        Object object = $this$isInClass.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return false;
        }
        Object qualifiedName = object;
        return Intrinsics.areEqual((Object)qualifiedName, (Object)name);
    }

    /*
     * WARNING - void declaration
     */
    private static final int lineEnd(CharSequence $this$lineEnd, int start) {
        void var2_2;
        int it = StringsKt.indexOf$default((CharSequence)$this$lineEnd, (char)'\n', (int)start, (boolean)false, (int)4, null);
        boolean bl = false;
        return it == -1 ? $this$lineEnd.length() : var2_2;
    }

    private static final int lineBegin(CharSequence $this$lineBegin, int start) {
        int it = StringsKt.lastIndexOf$default((CharSequence)$this$lineBegin, (char)'\n', (int)start, (boolean)false, (int)4, null);
        boolean bl = false;
        return it == -1 ? 0 : it + 1;
    }

    private static final boolean isNotBlankAt(CharSequence $this$isNotBlankAt, int start, int end) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)start, (int)end);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(!CharsKt.isWhitespace((char)$this$isNotBlankAt.charAt(it)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean equalsIgnoringSpace(@NotNull String $this$equalsIgnoringSpace, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$equalsIgnoringSpace, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int i = 0;
        int j = 0;
        int n = $this$equalsIgnoringSpace.length();
        int jn = other.length();
        while (true) {
            if (i < n && CharsKt.isWhitespace((char)$this$equalsIgnoringSpace.charAt(i))) {
                ++i;
                continue;
            }
            while (j < jn && CharsKt.isWhitespace((char)other.charAt(j))) {
                ++j;
            }
            if (i == n) {
                return j == jn;
            }
            if (j == jn) {
                return false;
            }
            if ($this$equalsIgnoringSpace.charAt(i) != other.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
    }

    public static final boolean containsIdentifier(@NotNull CharSequence $this$containsIdentifier, @NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)$this$containsIdentifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        int i = 0;
        int n = $this$containsIdentifier.length();
        while ((i = StringsKt.indexOf$default((CharSequence)$this$containsIdentifier, (String)identifier, (int)i, (boolean)false, (int)4, null)) != -1) {
            if (!(i != 0 && Character.isJavaIdentifierPart($this$containsIdentifier.charAt(i - 1)) || i + identifier.length() != n && Character.isJavaIdentifierPart($this$containsIdentifier.charAt(i + identifier.length())))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @NotNull
    public static final KtExpression skipParenthesizedExprDown(@NotNull KtExpression $this$skipParenthesizedExprDown) {
        Intrinsics.checkNotNullParameter((Object)$this$skipParenthesizedExprDown, (String)"<this>");
        KtExpression curr = $this$skipParenthesizedExprDown;
        while (curr instanceof KtParenthesizedExpression) {
            if (((KtParenthesizedExpression)curr).getExpression() != null) continue;
            return curr;
        }
        return curr;
    }

    public static final /* synthetic */ int access$lineBegin(CharSequence $receiver, int start) {
        return UseKtxDetectorKt.lineBegin($receiver, start);
    }

    public static final /* synthetic */ int access$lineEnd(CharSequence $receiver, int start) {
        return UseKtxDetectorKt.lineEnd($receiver, start);
    }

    public static final /* synthetic */ boolean access$isNotBlankAt(CharSequence $receiver, int start, int end) {
        return UseKtxDetectorKt.isNotBlankAt($receiver, start, end);
    }
}

