/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003J;\u0010\u0016\u001a\u00020\u00122\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0013\u0010 \u001a\u00020\u00012\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0017\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u0010!\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/checks/SizeConstraint;", "Lcom/android/tools/lint/checks/RangeConstraint;", "exact", "", "min", "max", "multiple", "<init>", "(JJJJ)V", "range", "Lcom/android/tools/lint/checks/IntRangeConstraint;", "(Lcom/android/tools/lint/checks/IntRangeConstraint;)V", "getExact", "()J", "getMin", "getMax", "getMultiple", "toString", "", "isValid", "", "actual", "describe", "argument", "Lorg/jetbrains/uast/UExpression;", "unit", "actualValue", "skipPrefix", "(Lorg/jetbrains/uast/UExpression;Ljava/lang/String;Ljava/lang/Long;Z)Ljava/lang/String;", "describeDelta", "actualLabel", "allowedLabel", "and", "other", "contains", "(Lcom/android/tools/lint/checks/RangeConstraint;)Ljava/lang/Boolean;", "Companion", "lint-checks"})
public final class SizeConstraint
extends RangeConstraint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long exact;
    private final long min;
    private final long max;
    private final long multiple;

    private SizeConstraint(long exact, long min, long max, long multiple) {
        this.exact = exact;
        this.min = min;
        this.max = max;
        this.multiple = multiple;
    }

    public final long getExact() {
        return this.exact;
    }

    public final long getMin() {
        return this.min;
    }

    public final long getMax() {
        return this.max;
    }

    public final long getMultiple() {
        return this.multiple;
    }

    public SizeConstraint(@NotNull IntRangeConstraint range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(range.getFrom() == range.getTo() ? range.getFrom() : -1L, range.getFrom(), range.getTo(), 1L);
    }

    @NotNull
    public String toString() {
        return SizeConstraint.describe$default(this, null, null, null, false, 8, null);
    }

    public final boolean isValid(long actual) {
        return !(this.exact != -1L ? this.exact != actual : actual < this.min || actual > this.max || actual % this.multiple != 0L);
    }

    @NotNull
    public final String describe(long argument) {
        return SizeConstraint.describe$default(this, null, null, argument, false, 8, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable String unit, @Nullable Long actualValue, boolean skipPrefix) {
        block22: {
            v0 = unit;
            if (v0 != null) break block22;
            v1 = argument;
            if ((v1 != null ? v1.getExpressionType() : null) == null) ** GOTO lbl-1000
            v2 = argument.getExpressionType();
            if (Intrinsics.areEqual((Object)(v2 != null ? v2.getCanonicalText() : null), (Object)"java.lang.String")) {
                v0 = "Length";
            } else lbl-1000:
            // 2 sources

            {
                v0 = actualUnit = "Size";
            }
        }
        if (actualValue != null && !this.isValid(actualValue)) {
            actual = actualValue;
            if (this.exact != -1L) {
                if (this.exact != actual) {
                    return "Expected " + actualUnit + " " + this.exact + " (was " + actual + ")";
                }
            } else {
                if (actual < this.min || actual > this.max) {
                    sb = new StringBuilder(20);
                    if (actual < this.min) {
                        sb.append("Expected ").append(actualUnit).append(" \u2265 ");
                        v3 = sb.append(String.valueOf(this.min));
                    } else {
                        v4 = var9_9 = actual > this.max;
                        if (_Assertions.ENABLED && !var9_9) {
                            var10_10 = "Assertion failed";
                            throw new AssertionError((Object)var10_10);
                        }
                        sb.append("Expected ").append(actualUnit).append(" \u2264 ");
                        v3 = sb.append(String.valueOf(this.max));
                    }
                    sb.append(" (was ").append(actual).append(')');
                    v5 = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toString(...)");
                    return v5;
                }
                if (actual % this.multiple != 0L) {
                    return "Expected " + actualUnit + " to be a multiple of " + this.multiple + " (was " + actual + " and should be either " + actual / this.multiple * this.multiple + " or " + (actual / this.multiple + 1L) * this.multiple + ")";
                }
            }
        }
        sb = new StringBuilder(20);
        if (!skipPrefix) {
            sb.append(actualUnit);
            sb.append(" must be ");
        }
        if (this.exact != -1L) {
            sb.append("exactly ");
            sb.append(String.valueOf(this.exact));
            v6 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toString(...)");
            return v6;
        }
        continued = true;
        if (this.min != -9223372036854775808L && this.max != 0x7FFFFFFFFFFFFFFFL) {
            sb.append("at least ");
            sb.append(String.valueOf(this.min));
            sb.append(" and at most ");
            v7 /* !! */  = sb.append(String.valueOf(this.max));
        } else if (this.min != -9223372036854775808L) {
            sb.append("at least ");
            v7 /* !! */  = sb.append(String.valueOf(this.min));
        } else if (this.max != 0x7FFFFFFFFFFFFFFFL) {
            sb.append("at most ");
            v7 /* !! */  = sb.append(String.valueOf(this.max));
        } else {
            continued = false;
            v7 /* !! */  = Unit.INSTANCE;
        }
        if (this.multiple != 1L) {
            if (continued) {
                sb.append(" and ");
            }
            sb.append("a multiple of ");
            sb.append(String.valueOf(this.multiple));
        }
        if (actualValue != null) {
            sb.append(" (was ").append(actualValue).append(')');
        }
        v8 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toString(...)");
        return v8;
    }

    public static /* synthetic */ String describe$default(SizeConstraint sizeConstraint, UExpression uExpression, String string, Long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uExpression = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return sizeConstraint.describe(uExpression, string, l, bl);
    }

    @Override
    @NotNull
    public String describeDelta(@NotNull RangeConstraint actual, @NotNull String actualLabel, @NotNull String allowedLabel) {
        StringBuilder stringBuilder;
        long other;
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)actualLabel, (String)"actualLabel");
        Intrinsics.checkNotNullParameter((Object)allowedLabel, (String)"allowedLabel");
        if (!(actual instanceof SizeConstraint)) {
            return SizeConstraint.describe$default(this, null, null, null, false, 15, null);
        }
        if (((SizeConstraint)actual).exact != -1L) {
            return this.describe(((SizeConstraint)actual).exact);
        }
        if (this.multiple != 1L && (other = ((SizeConstraint)actual).multiple) % this.multiple != 0L) {
            StringBuilder sb = new StringBuilder(SizeConstraint.describe$default(this, null, null, null, false, 15, null)).append(", but ");
            if (((CharSequence)actualLabel).length() > 0) {
                sb.append(actualLabel).append(" ");
            }
            StringBuilder stringBuilder2 = ((SizeConstraint)actual).multiple == 1L ? sb.append("is not a multiple of " + this.multiple) : sb.append("can be a multiple of " + ((SizeConstraint)actual).multiple);
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SizeConstraint.describe$default(this, null, null, null, false, 14, null));
        sb.append(", but ");
        if (((CharSequence)actualLabel).length() > 0) {
            sb.append(actualLabel).append(" ");
        }
        sb.append("can be ");
        if (this.max < ((SizeConstraint)actual).min && ((SizeConstraint)actual).max != Long.MAX_VALUE || this.min > ((SizeConstraint)actual).max && ((SizeConstraint)actual).min != Long.MIN_VALUE) {
            sb.append(((SizeConstraint)actual).describe(null, null, null, true));
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        if (((SizeConstraint)actual).min < this.min) {
            stringBuilder = ((SizeConstraint)actual).min == Long.MIN_VALUE ? sb.append("less than " + this.min) : sb.append(String.valueOf(((SizeConstraint)actual).min));
        } else if (((SizeConstraint)actual).max > this.max) {
            stringBuilder = ((SizeConstraint)actual).max == Long.MAX_VALUE ? sb.append("greater than " + this.max) : sb.append(String.valueOf(((SizeConstraint)actual).max));
        } else {
            throw new IllegalStateException("There's no delta".toString());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public RangeConstraint and(@Nullable RangeConstraint other) {
        SizeConstraint sizeConstraint;
        if (other == null) {
            return this;
        }
        RangeConstraint rangeConstraint = other;
        if (rangeConstraint instanceof SizeConstraint) {
            sizeConstraint = (SizeConstraint)other;
        } else if (rangeConstraint instanceof IntRangeConstraint) {
            sizeConstraint = new SizeConstraint((IntRangeConstraint)other);
        } else if (rangeConstraint instanceof FloatRangeConstraint) {
            sizeConstraint = new SizeConstraint(new IntRangeConstraint((FloatRangeConstraint)other));
        } else {
            String string = other.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        SizeConstraint range = sizeConstraint;
        long start = Math.max(this.exact != -1L ? this.exact : this.min, range.exact != -1L ? range.exact : range.min);
        long end = Math.min(this.exact != -1L ? this.exact : this.max, range.exact != -1L ? range.exact : range.max);
        return new SizeConstraint(start == end ? start : -1L, start, end, this.multiple);
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull RangeConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof SizeConstraint) {
            Boolean bl;
            if (this.exact != -1L && ((SizeConstraint)other).exact != -1L) {
                return this.exact == ((SizeConstraint)other).exact;
            }
            if (this.multiple != 1L && (((SizeConstraint)other).exact != -1L ? ((SizeConstraint)other).exact % this.multiple != 0L : ((SizeConstraint)other).multiple % this.multiple != 0L)) {
                return false;
            }
            if (((SizeConstraint)other).exact != -1L) {
                long l = this.min;
                long l2 = this.max;
                long l3 = ((SizeConstraint)other).exact;
                bl = l <= l3 ? l3 <= l2 : false;
            } else {
                bl = ((SizeConstraint)other).min >= this.min && ((SizeConstraint)other).max <= this.max;
            }
            return bl;
        }
        return null;
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable String unit, @Nullable Long actualValue) {
        return SizeConstraint.describe$default(this, argument, unit, actualValue, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable String unit) {
        return SizeConstraint.describe$default(this, argument, unit, null, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument) {
        return SizeConstraint.describe$default(this, argument, null, null, false, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe() {
        return SizeConstraint.describe$default(this, null, null, null, false, 15, null);
    }

    @JvmStatic
    @NotNull
    public static final SizeConstraint create(@NotNull UAnnotation annotation) {
        return Companion.create(annotation);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint exactly(long value) {
        return Companion.exactly(value);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint atLeast(long value) {
        return Companion.atLeast(value);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint atMost(long value) {
        return Companion.atMost(value);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint range(long from, long to) {
        return Companion.range(from, to);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint multiple(int multiple) {
        return Companion.multiple(multiple);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint rangeWithMultiple(long from, long to, int multiple) {
        return Companion.rangeWithMultiple(from, to, multiple);
    }

    public /* synthetic */ SizeConstraint(long exact, long min, long max, long multiple, DefaultConstructorMarker $constructor_marker) {
        this(exact, min, max, multiple);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/SizeConstraint$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/lint/checks/SizeConstraint;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "exactly", "value", "", "atLeast", "atMost", "range", "from", "to", "multiple", "", "rangeWithMultiple", "minWithMultiple", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SizeConstraint create(@NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            boolean bl = AnnotationDetectorKt.SIZE_ANNOTATION.isEquals(annotation.getQualifiedName());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            long exact = UastLintUtils.Companion.getAnnotationLongValue(annotation, "value", -1L);
            long min = UastLintUtils.Companion.getAnnotationLongValue(annotation, "min", Long.MIN_VALUE);
            long max = UastLintUtils.Companion.getAnnotationLongValue(annotation, "max", Long.MAX_VALUE);
            long multiple = UastLintUtils.Companion.getAnnotationLongValue(annotation, "multiple", 1L);
            return new SizeConstraint(exact, min, max, multiple, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint exactly(long value) {
            return new SizeConstraint(value, Long.MIN_VALUE, Long.MAX_VALUE, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint atLeast(long value) {
            return new SizeConstraint(-1L, value, Long.MAX_VALUE, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint atMost(long value) {
            return new SizeConstraint(-1L, Long.MIN_VALUE, value, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint range(long from, long to) {
            return new SizeConstraint(-1L, from, to, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint multiple(int multiple) {
            return new SizeConstraint(-1L, Long.MIN_VALUE, Long.MAX_VALUE, multiple, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint rangeWithMultiple(long from, long to, int multiple) {
            return new SizeConstraint(-1L, from, to, multiple, null);
        }

        @VisibleForTesting
        @NotNull
        public final SizeConstraint minWithMultiple(long from, int multiple) {
            return new SizeConstraint(-1L, from, Long.MAX_VALUE, multiple, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

