/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/PictureInPictureDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "afterCheckEachProject", "Lcom/android/tools/lint/detector/api/Context;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nPictureInPictureDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PictureInPictureDetector.kt\ncom/android/tools/lint/checks/PictureInPictureDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1869#2,2:196\n*S KotlinDebug\n*F\n+ 1 PictureInPictureDetector.kt\ncom/android/tools/lint/checks/PictureInPictureDetector\n*L\n165#1:196,2\n*E\n"})
public final class PictureInPictureDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PictureInPictureDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String FOUND_AUTO_ENTER_USAGE = "autoEnterUsage";
    @NotNull
    public static final String FOUND_SRC_RECT_HINT_USAGE = "sourceRectHintUsage";
    @NotNull
    public static final String FOUND_ENTER_PIP_MODE_USAGE = "enterPipMode";
    @NotNull
    public static final String FOUND_SET_PIP_PARAMS_USAGE = "pipParamsUsage";
    @NotNull
    public static final String ATTR_SUPPORTS_PICTURE_IN_PICTURE = "supportsPictureInPicture";

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setSourceRectHint", "setAutoEnterEnabled", "enterPictureInPictureMode", "setPictureInPictureParams", "trackPipAnimationHintView"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        LintMap map = context.getPartialResults(ISSUE).map();
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        String string = containingClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String containingClassFqn = string;
        if (PictureInPictureDetector.visitMethodCall$isMethod(method, containingClassFqn, context, containingClass, "setAutoEnterEnabled", "android.app.PictureInPictureParams.Builder")) {
            map.put(FOUND_AUTO_ENTER_USAGE, true);
        } else if (PictureInPictureDetector.visitMethodCall$isMethod(method, containingClassFqn, context, containingClass, "setSourceRectHint", "android.app.PictureInPictureParams.Builder")) {
            map.put(FOUND_SRC_RECT_HINT_USAGE, true);
        } else if (PictureInPictureDetector.visitMethodCall$isMethod(method, containingClassFqn, context, containingClass, "setPictureInPictureParams", "android.app.Activity")) {
            map.put(FOUND_SET_PIP_PARAMS_USAGE, true);
        } else if (PictureInPictureDetector.visitMethodCall$isMethod(method, containingClassFqn, context, containingClass, "enterPictureInPictureMode", "android.app.Activity")) {
            map.put(FOUND_ENTER_PIP_MODE_USAGE, true);
        } else if (Intrinsics.areEqual((Object)method.getName(), (Object)"trackPipAnimationHintView")) {
            map.put(FOUND_SRC_RECT_HINT_USAGE, true);
        }
    }

    public void afterCheckEachProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(ISSUE));
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        if (context.getProject().isLibrary()) {
            return;
        }
        if (context.getMainProject().getTargetSdk() < 31) {
            return;
        }
        Node node = context.getMainProject().getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null || (node = DomExtensions.subtag((Element)node, (String)"application")) == null) {
            return;
        }
        Node application = node;
        Element activity = DomExtensions.subtag((Element)application, (String)"activity");
        boolean isFoundPipActivity = false;
        while (activity != null) {
            if (Intrinsics.areEqual((Object)activity.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_SUPPORTS_PICTURE_IN_PICTURE), (Object)"true")) {
                isFoundPipActivity = true;
                break;
            }
            activity = DomExtensions.next((Element)activity, (String)"activity");
        }
        if (!isFoundPipActivity) {
            return;
        }
        LintMap combinedMap = new LintMap();
        Iterable $this$forEach$iv = partialResults.maps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LintMap it = (LintMap)element$iv;
            boolean bl = false;
            combinedMap.putAll(it);
        }
        if (!combinedMap.containsKey(FOUND_SET_PIP_PARAMS_USAGE) && !combinedMap.containsKey(FOUND_ENTER_PIP_MODE_USAGE)) {
            return;
        }
        if (combinedMap.containsKey(FOUND_AUTO_ENTER_USAGE) && combinedMap.containsKey(FOUND_SRC_RECT_HINT_USAGE)) {
            return;
        }
        context.report(IncidentKt.Incident((Context)context).issue(ISSUE).location(Context.getLocation$default((Context)context, (Object)application, null, (int)2, null)).message("An activity in this app supports picture-in-picture and the targetSdkVersion is 31 or above; it is therefore strongly recommended to call both `setAutoEnterEnabled(true)` and `setSourceRectHint(...)`"));
    }

    private static final boolean visitMethodCall$isMethod(PsiMethod $method, String containingClassFqn, JavaContext $context, PsiClass containingClass, String methodName, String classFqn) {
        return Intrinsics.areEqual((Object)$method.getName(), (Object)methodName) && (Intrinsics.areEqual((Object)containingClassFqn, (Object)classFqn) || $context.getEvaluator().extendsClass(containingClass, classFqn, false));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"PictureInPictureIssue", (String)"Picture In Picture best practices not followed", (String)"\n          Starting in Android 12, the recommended approach for enabling picture-in-picture (PiP) \\\n          has changed. If your app does not use the new approach, your app's transition animations \\\n          will be of poor quality compared to other apps. The new approach requires calling \\\n          `setAutoEnterEnabled(true)` and `setSourceRectHint(...)`.\n        ", (Implementation)implementation, (String)"https://developer.android.com/develop/ui/views/picture-in-picture#smoother-transition", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/PictureInPictureDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "FOUND_AUTO_ENTER_USAGE", "", "FOUND_SRC_RECT_HINT_USAGE", "FOUND_ENTER_PIP_MODE_USAGE", "FOUND_SET_PIP_PARAMS_USAGE", "ATTR_SUPPORTS_PICTURE_IN_PICTURE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

