/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaApplicableCallCandidateInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallCandidateInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCompoundArrayAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCompoundVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KaCallableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaTypeNullability;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/MemberExtensionConflictDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "Companion", "lint-checks"})
public final class MemberExtensionConflictDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MemberExtensionConflictDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String MSG = "Conflict applicable candidates of member and extension";
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MemberExtensionConflict", (String)"Conflict applicable candidates of member and extension", (String)"\n            When both member and extension declarations are applicable, the resolution takes the member. \\\n            This also implies that, if an extension existed first, but then a member is added later, \\\n            the same call-site may end up with different call resolutions depending on target environment. \\\n            This results in a potential runtime exception if the generated binary (library or app) targets \\\n            earlier environment (i.e., without the new member, but only extension). More concrete example \\\n            is found at: https://issuetracker.google.com/issues/350432371\n          ", (Implementation)IMPLEMENTATION, null, null, (int)0, null, (boolean)false, null, null, null, (int)3824, null);

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, USimpleNameReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(UCallExpression node) {
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Lint.isKotlin((Language)node.getLang())) {
                    return;
                }
                PsiElement psiElement = node.getSourcePsi();
                KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
                if (ktElement == null) {
                    return;
                }
                KtElement sourcePsi = ktElement;
                boolean $i$f$analyze = false;
                Project project = sourcePsi.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiElement = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(sourcePsi);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, sourcePsi);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        KaSession $this$visitCallExpression_u24lambda_u240;
                        block12: {
                            boolean bl = false;
                            $this$visitCallExpression_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (this.isK2($this$visitCallExpression_u24lambda_u240)) break block12;
                            return;
                        }
                        this.checkKtElement($this$visitCallExpression_u24lambda_u240, (UElement)node, sourcePsi);
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, sourcePsi);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, sourcePsi);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Lint.isKotlin((Language)node.getLang())) {
                    return;
                }
                PsiElement psiElement = node.getSourcePsi();
                KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
                if (ktElement == null) {
                    return;
                }
                KtElement sourcePsi = ktElement;
                boolean $i$f$analyze = false;
                Project project = sourcePsi.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiElement = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(sourcePsi);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, sourcePsi);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        KaSession $this$visitSimpleNameReferenceExpression_u24lambda_u241;
                        block12: {
                            boolean bl = false;
                            $this$visitSimpleNameReferenceExpression_u24lambda_u241 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (this.isK2($this$visitSimpleNameReferenceExpression_u24lambda_u241)) break block12;
                            return;
                        }
                        this.checkKtElement($this$visitSimpleNameReferenceExpression_u24lambda_u241, (UElement)node, sourcePsi);
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, sourcePsi);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, sourcePsi);
                }
            }

            private final boolean isK2(KaSession $this$isK2) {
                return Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass($this$isK2.getClass()).getSimpleName(), (Object)"KaFirSession");
            }

            /*
             * WARNING - void declaration
             */
            private final void checkKtElement(KaSession $this$checkKtElement, UElement node, KtElement ktElement) {
                void $this$filterNotTo$iv$iv;
                Object v1;
                List extensions;
                block9: {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    Iterable iterable = $this$checkKtElement.resolveToCallCandidates(ktElement);
                    boolean $i$f$filterIsInstance = false;
                    void var7_7 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof KaApplicableCallCandidateInfo)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List candidates = (List)destination$iv$iv;
                    if (candidates.size() <= 1) {
                        return;
                    }
                    Iterable $this$partition$iv = candidates;
                    boolean $i$f$partition = false;
                    ArrayList<T> first$iv = new ArrayList<T>();
                    ArrayList<T> second$iv = new ArrayList<T>();
                    for (T element$iv : $this$partition$iv) {
                        KaApplicableCallCandidateInfo it = (KaApplicableCallCandidateInfo)element$iv;
                        boolean bl = false;
                        boolean bl2 = this.hasExtensionReceiver(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
                    }
                    iterable = new Pair(first$iv, second$iv);
                    extensions = (List)iterable.component1();
                    List members = (List)iterable.component2();
                    if (members.isEmpty()) {
                        return;
                    }
                    Iterable $this$singleOrNull$iv = members;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        KaApplicableCallCandidateInfo it = (KaApplicableCallCandidateInfo)element$iv;
                        boolean bl = false;
                        if (!it.isInBestCandidates()) continue;
                        if (found$iv) {
                            v1 = null;
                            break block9;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                KaApplicableCallCandidateInfo filteredMember = v1;
                if (filteredMember == null) {
                    return;
                }
                Iterable $this$filterNot$iv = extensions;
                boolean $i$f$filterNot = false;
                Iterable found$iv = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    KaApplicableCallCandidateInfo ext = (KaApplicableCallCandidateInfo)element$iv$iv;
                    boolean bl = false;
                    if (this.isFromKotlinBuiltIns(ext) && (this.hasNullableExtensionReceiver(ext) || this.hasNullableValueParameters(ext))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredExtensions = (List)destination$iv$iv;
                if (filteredExtensions.isEmpty()) {
                    return;
                }
                this.reportConflict($this$checkKtElement, node, (KaCallCandidateInfo)filteredMember, (KaCallCandidateInfo)CollectionsKt.first((List)filteredExtensions));
            }

            private final KaPartiallyAppliedSymbol<?, ?> partialSymbol(KaApplicableCallCandidateInfo $this$partialSymbol) {
                KaCall kaCall = $this$partialSymbol.getCandidate();
                KaCallableMemberCall kaCallableMemberCall = kaCall instanceof KaCallableMemberCall ? (KaCallableMemberCall)kaCall : null;
                return kaCallableMemberCall != null ? kaCallableMemberCall.getPartiallyAppliedSymbol() : null;
            }

            private final boolean hasExtensionReceiver(KaApplicableCallCandidateInfo $this$hasExtensionReceiver) {
                KaPartiallyAppliedSymbol<?, ?> kaPartiallyAppliedSymbol = this.partialSymbol($this$hasExtensionReceiver);
                return (kaPartiallyAppliedSymbol != null ? kaPartiallyAppliedSymbol.getExtensionReceiver() : null) != null;
            }

            private final boolean hasNullableExtensionReceiver(KaApplicableCallCandidateInfo $this$hasNullableExtensionReceiver) {
                KaCallableSignature kaCallableSignature = this.partialSymbol($this$hasNullableExtensionReceiver);
                return (kaCallableSignature != null && (kaCallableSignature = kaCallableSignature.getSignature()) != null && (kaCallableSignature = kaCallableSignature.getReceiverType()) != null ? kaCallableSignature.getNullability() : null) == KaTypeNullability.NULLABLE;
            }

            private final boolean hasNullableValueParameters(KaApplicableCallCandidateInfo $this$hasNullableValueParameters) {
                boolean bl;
                block4: {
                    KaPartiallyAppliedSymbol<?, ?> kaPartiallyAppliedSymbol = this.partialSymbol($this$hasNullableValueParameters);
                    Object object = kaPartiallyAppliedSymbol != null ? KaPartiallyAppliedSymbolKt.getSymbol(kaPartiallyAppliedSymbol) : null;
                    Object object2 = object instanceof KaFunctionSymbol ? (KaFunctionSymbol)object : null;
                    if (object2 == null || (object2 = object2.getValueParameters()) == null) {
                        return false;
                    }
                    Object valueParameters = object2;
                    Iterable $this$all$iv = (Iterable)valueParameters;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            KaValueParameterSymbol it = (KaValueParameterSymbol)element$iv;
                            boolean bl2 = false;
                            if (it.getReturnType().getNullability() == KaTypeNullability.NULLABLE) continue;
                            bl = false;
                            break block4;
                        }
                        bl = true;
                    }
                }
                return bl;
            }

            private final boolean isFromKotlinBuiltIns(KaApplicableCallCandidateInfo $this$isFromKotlinBuiltIns) {
                FqName fqName;
                CallableId callableId;
                KaCallableSignature kaCallableSignature;
                KaPartiallyAppliedSymbol<?, ?> kaPartiallyAppliedSymbol = this.partialSymbol($this$isFromKotlinBuiltIns);
                return kaPartiallyAppliedSymbol != null && (kaCallableSignature = kaPartiallyAppliedSymbol.getSignature()) != null && (callableId = kaCallableSignature.getCallableId()) != null && (fqName = callableId.getPackageName()) != null ? fqName.startsWith(StandardNames.BUILT_INS_PACKAGE_FQ_NAME) : false;
            }

            private final void reportConflict(KaSession $this$reportConflict, UElement node, KaCallCandidateInfo member, KaCallCandidateInfo extension) {
                KaSymbol mem = this.symbol(member.getCandidate());
                Object object = this.symbol(extension.getCandidate());
                KaCallableSymbol kaCallableSymbol = object instanceof KaCallableSymbol ? (KaCallableSymbol)object : null;
                if (kaCallableSymbol == null) {
                    return;
                }
                KaCallableSymbol ext = kaCallableSymbol;
                Object $this$reportConflict_u24lambda_u246 = object = new StringBuilder();
                boolean bl = false;
                Object object2 = KaSymbolKt.getName((KaSymbol)mem);
                if (object2 == null || (object2 = object2.asString()) == null) {
                    object2 = "<unnamed>";
                }
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("`" + (String)object2 + "`");
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append(" is defined both as a member in class ");
                KaDeclarationSymbol kaDeclarationSymbol = $this$reportConflict.getContainingDeclaration(mem);
                KaClassSymbol classSymbol = kaDeclarationSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaDeclarationSymbol : null;
                Object object3 = classSymbol;
                if (object3 == null || (object3 = object3.getClassId()) == null || (object3 = object3.asFqNameString()) == null) {
                    object3 = "<unknown>";
                }
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("`" + (String)object3 + "`");
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append(" and an extension in package ");
                Object object4 = ext.getCallableId();
                if (object4 == null || (object4 = object4.getPackageName()) == null || (object4 = object4.asString()) == null) {
                    object4 = "<unknown>";
                }
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("`" + (String)object4 + "`. ");
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("The defined behavior for this is to use the member, ");
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("but since the extension is explicitly imported into this file, ");
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("there's a chance that this was not expected. ");
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("(One common way this happens is for members to be added to a class ");
                ((StringBuilder)$this$reportConflict_u24lambda_u246).append("after code was already written to use an extension).");
                String message2 = ((StringBuilder)object).toString();
                JavaContext.report$default((JavaContext)this.$context, (Issue)MemberExtensionConflictDetector.ISSUE, (UElement)node, (Location)this.$context.getLocation(node), (String)message2, null, (int)16, null);
            }

            private final KaSymbol symbol(KaCall $this$symbol) {
                KaSymbol kaSymbol;
                KaCall kaCall = $this$symbol;
                if (kaCall instanceof KaCompoundVariableAccessCall) {
                    kaSymbol = (KaSymbol)KaPartiallyAppliedSymbolKt.getSymbol((KaPartiallyAppliedSymbol)((KaCompoundVariableAccessCall)$this$symbol).getCompoundOperation().getOperationPartiallyAppliedSymbol());
                } else if (kaCall instanceof KaCompoundArrayAccessCall) {
                    kaSymbol = (KaSymbol)KaPartiallyAppliedSymbolKt.getSymbol((KaPartiallyAppliedSymbol)((KaCompoundArrayAccessCall)$this$symbol).getCompoundOperation().getOperationPartiallyAppliedSymbol());
                } else if (kaCall instanceof KaCallableMemberCall) {
                    kaSymbol = (KaSymbol)KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)$this$symbol));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return kaSymbol;
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/MemberExtensionConflictDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MSG", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

