/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum Navigation implements ResourceEnum
{
    NONAV("nonav", "None", "No navigation"),
    DPAD("dpad", "D-pad", "D-pad navigation"),
    TRACKBALL("trackball", "Trackball", "Trackball navigation"),
    WHEEL("wheel", "Wheel", "Wheel navigation");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private Navigation(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static Navigation getEnum(String value) {
        for (Navigation nav : Navigation.values()) {
            if (!nav.mValue.equals(value)) continue;
            return nav;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(Navigation value) {
        return value == null ? -1 : value.ordinal();
    }

    public static Navigation getByIndex(int index) {
        Navigation[] values = Navigation.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

