/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataElement;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnreportedDuplicateDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.resolve.calls.AmbiguousContextArgument;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitValue;
import org.jetbrains.kotlin.fir.resolve.calls.NoContextArgument;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.UnsupportedContextualDeclarationCall;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ImplicitArgumentDescription;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010*\u00020\u0007H\u0002J\u0014\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010*\u00020\u0007H\u0002J2\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0010*\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010*\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00100\u0010H\u0002J$\u0010\u001e\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0010H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckContextArguments;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "obtainInvokeContextParametersOrNull", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "obtainRegularContextParametersOrNull", "mapContextArgumentsOrNull", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "contextSymbols", "towerDataContext", "Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;", "findClosestMatchingContextArguments", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ImplicitArgumentDescription;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "implicitGroups", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues", "count", "", "resultingContextArguments", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckContextArguments\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1053:1\n1#2:1054\n1#2:1083\n1504#3:1055\n1534#3,3:1056\n1537#3,3:1066\n1617#3,9:1069\n1869#3:1078\n1563#3:1079\n1634#3,3:1080\n1870#3:1084\n1626#3:1085\n1563#3:1086\n1634#3,3:1087\n774#3:1090\n865#3,2:1091\n382#4,7:1059\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckContextArguments\n*L\n271#1:1083\n263#1:1055\n263#1:1056,3\n263#1:1066,3\n271#1:1069,9\n271#1:1078\n273#1:1079\n273#1:1080,3\n271#1:1084\n271#1:1085\n309#1:1086\n309#1:1087,3\n310#1:1090\n310#1:1091,2\n263#1:1059,7\n*E\n"})
public final class CheckContextArguments
extends ResolutionStage {
    @NotNull
    public static final CheckContextArguments INSTANCE = new CheckContextArguments();

    private CheckContextArguments() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        List<FirValueParameterSymbol> list = this.obtainInvokeContextParametersOrNull(candidate2);
        if (list == null && (list = this.obtainRegularContextParametersOrNull(candidate2)) == null) {
            return Unit.INSTANCE;
        }
        List<FirValueParameterSymbol> contextSymbols = list;
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ContextParameters) && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ContextReceivers)) {
            sink.reportDiagnostic(UnsupportedContextualDeclarationCall.INSTANCE);
            return Unit.INSTANCE;
        }
        List<ConeResolutionAtom> resultingContextArguments = this.mapContextArgumentsOrNull(candidate2, contextSymbols, context2.getBodyResolveContext().getTowerDataContext(), sink);
        Integer contextParameterCountForInvoke = candidate2.getExpectedContextParameterCountForInvoke();
        if (contextParameterCountForInvoke == null) {
            candidate2.setContextArguments(resultingContextArguments);
        } else {
            this.replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues(candidate2, contextParameterCountForInvoke, resultingContextArguments);
        }
        return Unit.INSTANCE;
    }

    private final List<FirValueParameterSymbol> obtainInvokeContextParametersOrNull(Candidate $this$obtainInvokeContextParametersOrNull) {
        Integer n = $this$obtainInvokeContextParametersOrNull.getExpectedContextParameterCountForInvoke();
        if (n == null) {
            return null;
        }
        int count = n;
        FirBasedSymbol<?> firBasedSymbol = $this$obtainInvokeContextParametersOrNull.getSymbol();
        Object object = firBasedSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol : null;
        return object != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null ? CollectionsKt.take((Iterable)((Iterable)object), (int)count) : null;
    }

    private final List<FirValueParameterSymbol> obtainRegularContextParametersOrNull(Candidate $this$obtainRegularContextParametersOrNull) {
        FirBasedSymbol<?> firBasedSymbol;
        FirCallableSymbol firCallableSymbol;
        FirBasedSymbol<?> firBasedSymbol2 = $this$obtainRegularContextParametersOrNull.getSymbol();
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol = firBasedSymbol2 instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol2 : null;
        if (firCallableSymbol != null && (firBasedSymbol2 = firCallableSymbol.getContextParameterSymbols()) != null) {
            FirBasedSymbol<?> firBasedSymbol3;
            FirBasedSymbol<?> it = firBasedSymbol3 = firBasedSymbol2;
            boolean bl = false;
            firBasedSymbol = !it.isEmpty() ? firBasedSymbol3 : null;
        } else {
            firBasedSymbol = null;
        }
        return firBasedSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeResolutionAtom> mapContextArgumentsOrNull(Candidate $this$mapContextArgumentsOrNull, List<FirValueParameterSymbol> contextSymbols, FirTowerDataContext towerDataContext, CheckerSink sink) {
        List list;
        block16: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$groupByTo$iv$iv;
            Object destination$iv$iv;
            block15: {
                void $this$groupBy$iv;
                if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$mapContextArgumentsOrNull.getCallInfo().getSession()).supportsFeature(LanguageFeature.ContextParameters)) break block15;
                Iterable iterable = towerDataContext.getImplicitValueStorage().getImplicitValues();
                boolean $i$f$groupBy = false;
                void var8_8 = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    void it;
                    Object object;
                    ImplicitValue it2 = (ImplicitValue)element$iv$iv;
                    boolean $i$a$-groupBy-CheckContextArguments$mapContextArgumentsOrNull$implicitsGroupedByScope$32 = false;
                    FirBasedSymbol key$iv$iv = ResolutionStagesKt.access$containingDeclarationIfParameter(it2.getBoundSymbol());
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    ImplicitValue $i$a$-groupBy-CheckContextArguments$mapContextArgumentsOrNull$implicitsGroupedByScope$32 = (ImplicitValue)element$iv$iv;
                    List list2 = list$iv$iv;
                    boolean bl = false;
                    list2.add(it.computeExpression());
                }
                list = CollectionsKt.reversed((Iterable)destination$iv$iv.values());
                break block16;
            }
            Iterable $this$mapNotNull$iv = CollectionsKt.asReversed((List)towerDataContext.getTowerDataElements());
            boolean $i$f$mapNotNull = false;
            $this$groupByTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ImplicitReceiverValue<?> implicitReceiverValue;
                block18: {
                    FirTowerDataElement towerDataElement;
                    block17: {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        towerDataElement = (FirTowerDataElement)element$iv$iv;
                        boolean bl2 = false;
                        implicitReceiverValue = towerDataElement.getImplicitReceiver();
                        if (implicitReceiverValue == null || (implicitReceiverValue = implicitReceiverValue.getReceiverExpression()) == null) break block17;
                        ImplicitReceiverValue<?> p0 = implicitReceiverValue;
                        boolean bl3 = false;
                        List list3 = CollectionsKt.listOf((Object)p0);
                        implicitReceiverValue = list3;
                        if (list3 != null) break block18;
                    }
                    List<ImplicitValue<?>> list4 = towerDataElement.getImplicitContextGroup();
                    if (list4 != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = list4;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ImplicitValue implicitValue = (ImplicitValue)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl = false;
                            collection.add(it.computeExpression());
                        }
                        implicitReceiverValue = (List)destination$iv$iv2;
                    } else {
                        implicitReceiverValue = null;
                    }
                }
                if (implicitReceiverValue == null) continue;
                ImplicitReceiverValue<?> it$iv$iv = implicitReceiverValue;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List implicitsGroupedByScope = list;
        List resultingContextArguments = new ArrayList();
        block7: for (FirValueParameterSymbol symbol : contextSymbols) {
            ConeKotlinType expectedType = $this$mapContextArgumentsOrNull.getSubstitutor().substituteOrSelf(symbol.getResolvedReturnType());
            List<ImplicitArgumentDescription> potentialContextArguments = this.findClosestMatchingContextArguments($this$mapContextArgumentsOrNull, expectedType, implicitsGroupedByScope);
            switch (potentialContextArguments.size()) {
                case 0: {
                    sink.reportDiagnostic(new NoContextArgument(symbol));
                    return null;
                }
                case 1: {
                    ImplicitArgumentDescription matchingReceiver = (ImplicitArgumentDescription)CollectionsKt.single(potentialContextArguments);
                    resultingContextArguments.add(matchingReceiver.getAtom());
                    $this$mapContextArgumentsOrNull.getSystem().addSubtypeConstraint(matchingReceiver.getType(), expectedType, SimpleConstraintSystemConstraintPosition.INSTANCE);
                    continue block7;
                }
            }
            sink.reportDiagnostic(new AmbiguousContextArgument(expectedType));
            return null;
        }
        return resultingContextArguments;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ImplicitArgumentDescription> findClosestMatchingContextArguments(Candidate $this$findClosestMatchingContextArguments, ConeKotlinType expectedType, List<? extends List<? extends FirExpression>> implicitGroups) {
        for (List<? extends FirExpression> list : implicitGroups) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ImplicitArgumentDescription it;
            boolean bl;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = list;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl = false;
                collection.add(ResolutionStagesKt.access$prepareImplicitArgument(ConeResolutionAtom.Companion.createRawAtom((FirExpression)((Object)it)), expectedType, $this$findClosestMatchingContextArguments.getCallInfo().getSession()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ImplicitArgumentDescription)element$iv$iv;
                bl = false;
                if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible($this$findClosestMatchingContextArguments.getSystem(), it.getType(), expectedType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List currentResult = (List)destination$iv$iv;
            if (!(!((Collection)currentResult).isEmpty())) continue;
            return currentResult;
        }
        return CollectionsKt.emptyList();
    }

    private final void replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues(Candidate $this$replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues, int count, List<? extends ConeResolutionAtom> resultingContextArguments) {
        List newArgumentPrefix = new ArrayList();
        for (int j = 0; j < count; ++j) {
            int index2 = j;
            boolean bl = false;
            List<? extends ConeResolutionAtom> list = resultingContextArguments;
            if (list == null || (list = list.get(index2)) == null) {
                list = ConeResolutionAtom.Companion.createRawAtom(FirExpressionUtilKt.buildErrorExpression$default($this$replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues.getCallInfo().getCallSite().getSource(), new ConeUnreportedDuplicateDiagnostic(new ConeSimpleDiagnostic("Unresolved context argument", DiagnosticKind.Other)), null, 4, null));
            }
            List<? extends ConeResolutionAtom> newValue = list;
            newArgumentPrefix.add(newValue);
        }
        $this$replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues.replaceArgumentPrefix(newArgumentPrefix);
    }
}

