/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex;", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "<init>", "(Ljava/util/List;)V", "classIdsInRoots", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/collections/ArrayList;", "findJavaSourceClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "hasPackage", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "findJavaSourceClasses", "getClassIdsForRootAt", "index", "", "JavaSourceClassIdReader", "cli-base"})
@SourceDebugExtension(value={"SMAP\nSingleJavaFileRootsIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleJavaFileRootsIndex.kt\norg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n1761#3,3:135\n1374#3:138\n1460#3,5:139\n774#3:144\n865#3,2:145\n*S KotlinDebug\n*F\n+ 1 SingleJavaFileRootsIndex.kt\norg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex\n*L\n45#1:135,3\n51#1:138\n51#1:139,5\n51#1:144\n51#1:145,2\n*E\n"})
public final class SingleJavaFileRootsIndex {
    @NotNull
    private final List<JavaRoot> roots;
    @NotNull
    private final ArrayList<List<ClassId>> classIdsInRoots;

    public SingleJavaFileRootsIndex(@NotNull List<JavaRoot> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        this.roots = roots;
        Iterator<JavaRoot> iterator2 = this.roots.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            VirtualFile file = iterator2.next().component1();
            boolean bl2 = bl = !file.isDirectory();
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl3 = false;
            String string = "Should not be a directory: " + file;
            throw new AssertionError((Object)string);
        }
        this.classIdsInRoots = new ArrayList(this.roots.size());
    }

    @Nullable
    public final VirtualFile findJavaSourceClass(@NotNull ClassId classId) {
        VirtualFile virtualFile;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)this.roots);
            for (Object t : iterable) {
                int index2 = ((Number)t).intValue();
                boolean bl = false;
                if (!this.getClassIdsForRootAt(index2).contains(classId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Integer n = v0;
        if (n != null) {
            int index3 = ((Number)n).intValue();
            boolean bl = false;
            virtualFile = this.roots.get(index3).getFile();
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    public final boolean hasPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        int n = ((Collection)this.roots).size();
        for (int i2 = 0; i2 < n; ++i2) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.getClassIdsForRootAt(i2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ClassId it = (ClassId)element$iv;
                        boolean bl2 = false;
                        if (!it.getPackageFqName().startsWith(packageFqName)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassId> findJavaSourceClasses(@NotNull FqName packageFqName) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Iterable $this$flatMap$iv = (Iterable)CollectionsKt.getIndices((Collection)this.roots);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int p0 = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable list$iv$iv = this.getClassIdsForRootAt(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassId root = (ClassId)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)root.getPackageFqName(), (Object)packageFqName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ClassId> getClassIdsForRootAt(int index2) {
        int i2 = this.classIdsInRoots.size();
        if (i2 <= index2) {
            while (true) {
                this.classIdsInRoots.add(new JavaSourceClassIdReader(this.roots.get(i2).getFile()).readClassIds());
                if (i2 == index2) break;
                ++i2;
            }
        }
        List<ClassId> list = this.classIdsInRoots.get(index2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex$JavaSourceClassIdReader;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "lexer", "Lcom/intellij/lang/java/lexer/JavaLexer;", "braceBalance", "", "parenthesisBalance", "at", "", "type", "Lcom/intellij/psi/tree/IElementType;", "end", "advance", "", "tokenText", "", "atClass", "atRecord", "readClassIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Companion", "cli-base"})
    private static final class JavaSourceClassIdReader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JavaLexer lexer;
        private int braceBalance;
        private int parenthesisBalance;
        @NotNull
        private static final Set<IElementType> CLASS_KEYWORDS;

        /*
         * WARNING - void declaration
         */
        public JavaSourceClassIdReader(@NotNull VirtualFile file) {
            void $this$lexer_u24lambda_u240;
            JavaLexer javaLexer;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            JavaLexer javaLexer2 = javaLexer = new JavaLexer(LanguageLevel.HIGHEST);
            JavaSourceClassIdReader javaSourceClassIdReader = this;
            boolean bl = false;
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] byArray2 = byArray;
            $this$lexer_u24lambda_u240.start((CharSequence)new String(byArray2, Charsets.UTF_8));
            javaSourceClassIdReader.lexer = javaLexer;
        }

        private final boolean at(IElementType type) {
            return Intrinsics.areEqual((Object)this.lexer.getTokenType(), (Object)type);
        }

        private final boolean end() {
            return this.lexer.getTokenType() == null;
        }

        private final void advance() {
            IElementType iElementType = ElementType.LBRACE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"LBRACE");
            if (this.at(iElementType)) {
                int n = this.braceBalance;
                this.braceBalance = n + 1;
            } else {
                IElementType iElementType2 = ElementType.RBRACE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"RBRACE");
                if (this.at(iElementType2)) {
                    int n = this.braceBalance;
                    this.braceBalance = n + -1;
                } else {
                    IElementType iElementType3 = ElementType.LPARENTH;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"LPARENTH");
                    if (this.at(iElementType3)) {
                        int n = this.parenthesisBalance;
                        this.parenthesisBalance = n + 1;
                    } else {
                        IElementType iElementType4 = ElementType.RPARENTH;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"RPARENTH");
                        if (this.at(iElementType4)) {
                            int n = this.parenthesisBalance;
                            this.parenthesisBalance = n + -1;
                        }
                    }
                }
            }
            this.lexer.advance();
        }

        private final String tokenText() {
            String string = this.lexer.getTokenText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
            return string;
        }

        private final boolean atClass() {
            return this.braceBalance == 0 && this.parenthesisBalance == 0 && (CLASS_KEYWORDS.contains(this.lexer.getTokenType()) || this.atRecord());
        }

        private final boolean atRecord() {
            IElementType iElementType = ElementType.IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"IDENTIFIER");
            return this.at(iElementType) && Intrinsics.areEqual((Object)this.tokenText(), (Object)"record");
        }

        @NotNull
        public final List<ClassId> readClassIds() {
            FqName packageFqName;
            block8: {
                packageFqName = FqName.ROOT;
                while (!this.end()) {
                    IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PACKAGE_KEYWORD");
                    if (this.at(iElementType) || this.atClass()) break;
                    this.advance();
                }
                IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PACKAGE_KEYWORD");
                if (!this.at(iElementType)) break block8;
                StringBuilder packageName2 = new StringBuilder();
                while (!this.end()) {
                    block10: {
                        block9: {
                            IElementType iElementType2 = ElementType.SEMICOLON;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"SEMICOLON");
                            if (this.at(iElementType2)) break;
                            IElementType iElementType3 = ElementType.IDENTIFIER;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"IDENTIFIER");
                            if (this.at(iElementType3)) break block9;
                            IElementType iElementType4 = ElementType.DOT;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"DOT");
                            if (!this.at(iElementType4)) break block10;
                        }
                        packageName2.append(this.tokenText());
                    }
                    this.advance();
                }
                String string = packageName2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                packageFqName = new FqName(string);
            }
            ArrayList<ClassId> result2 = new ArrayList<ClassId>(1);
            while (true) {
                if (!this.end() && !this.atClass()) {
                    this.advance();
                    continue;
                }
                if (this.end()) break;
                this.advance();
                while (!this.end()) {
                    IElementType iElementType = ElementType.IDENTIFIER;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"IDENTIFIER");
                    if (this.at(iElementType)) break;
                    this.advance();
                }
                if (this.end()) break;
                Name name2 = Name.identifier(this.tokenText());
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                result2.add(new ClassId(packageFqName, name2));
            }
            return result2;
        }

        static {
            Object[] objectArray = new IElementType[]{ElementType.CLASS_KEYWORD, ElementType.INTERFACE_KEYWORD, ElementType.ENUM_KEYWORD};
            CLASS_KEYWORDS = SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/SingleJavaFileRootsIndex$JavaSourceClassIdReader$Companion;", "", "<init>", "()V", "CLASS_KEYWORDS", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "cli-base"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

