/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallMetrics;
import com.android.ddmlib.InstallReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.SplitApkInstallerBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SplitApkInstaller
extends SplitApkInstallerBase {
    private static final String LOG_TAG = "SplitApkInstaller";
    private final List<File> mApks;

    private SplitApkInstaller(IDevice device, List<File> apks, String options) {
        super(device, options);
        this.mApks = apks;
    }

    public InstallMetrics install(long timeout, TimeUnit unit) throws InstallException {
        try {
            long totalFileSize = 0L;
            for (File apkFile : this.mApks) {
                totalFileSize += apkFile.length();
            }
            Object option = String.format("-S %d", totalFileSize);
            if (this.getOptions() != null) {
                option = this.getOptions() + " " + (String)option;
            }
            String sessionId = this.createMultiInstallSession((String)option, timeout, unit);
            int index = 0;
            boolean allUploadSucceeded = true;
            long uploadStartNs = System.nanoTime();
            while (allUploadSucceeded && index < this.mApks.size()) {
                allUploadSucceeded = this.uploadApk(sessionId, this.mApks.get(index), index++, timeout, unit);
            }
            long uploadFinishNs = System.nanoTime();
            if (!allUploadSucceeded) {
                this.installAbandon(sessionId, timeout, unit);
                throw new InstallException("Failed to install-write all apks");
            }
            this.installCommit(sessionId, timeout, unit);
            Log.d(LOG_TAG, "Successfully install apks: " + this.mApks.toString());
            return new InstallMetrics(uploadStartNs, uploadFinishNs, uploadFinishNs, System.nanoTime());
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean uploadApk(String sessionId, File fileToUpload, int uniqueId, long timeout, TimeUnit unit) {
        Log.i(LOG_TAG, String.format("Uploading APK %s to session %s", fileToUpload.getPath(), sessionId));
        if (!fileToUpload.exists()) {
            Log.e(LOG_TAG, String.format("File not found: %1$s", fileToUpload.getPath()));
            return false;
        }
        if (fileToUpload.isDirectory()) {
            Log.e(LOG_TAG, String.format("Directory upload not supported: %s", fileToUpload.getAbsolutePath()));
            return false;
        }
        String baseName = fileToUpload.getName().lastIndexOf(46) != -1 ? fileToUpload.getName().substring(0, fileToUpload.getName().lastIndexOf(46)) : fileToUpload.getName();
        baseName = UNSAFE_PM_INSTALL_SESSION_SPLIT_NAME_CHARS.replaceFrom((CharSequence)baseName, '_');
        String command = String.format(this.getPrefix() + " install-write -S %d %s %d_%s -", fileToUpload.length(), sessionId, uniqueId, baseName);
        Log.d(LOG_TAG, String.format("Executing : %1$s", command));
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(fileToUpload));
            InstallReceiver receiver = new InstallReceiver();
            AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), this.getServiceWrite(), command, this.getDevice(), receiver, timeout, unit, inputStream);
            if (receiver.isSuccessfullyCompleted()) {
                Log.d(LOG_TAG, String.format("Successfully uploaded %1$s", fileToUpload.getName()));
            } else {
                Log.e(LOG_TAG, String.format("Error while uploading %1$s : %2$s", fileToUpload.getName(), receiver.getErrorMessage()));
            }
            boolean bl = receiver.isSuccessfullyCompleted();
            return bl;
        }
        catch (Exception e) {
            Log.e(sessionId, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Log.e(sessionId, e);
                }
            }
        }
    }

    private static void validateArguments(IDevice device, List<File> apks) {
        SplitApkInstaller.validateApiLevel(device);
        if (apks.isEmpty()) {
            throw new IllegalArgumentException("List of APKs is empty: the main APK must be specified.");
        }
        for (File apk : apks) {
            if (apk.isFile()) continue;
            throw new IllegalArgumentException("Invalid File: " + apk.getPath());
        }
    }

    public static SplitApkInstaller create(IDevice device, List<File> apks, boolean reInstall, List<String> installOptions) {
        SplitApkInstaller.validateArguments(device, apks);
        return new SplitApkInstaller(device, apks, SplitApkInstaller.getOptions(reInstall, installOptions));
    }

    public static SplitApkInstaller create(IDevice device, String applicationId, List<File> apks, boolean reInstall, List<String> installOptions) {
        SplitApkInstaller.validateArguments(device, apks);
        return new SplitApkInstaller(device, apks, SplitApkInstaller.getOptions(reInstall, true, applicationId, installOptions));
    }
}

