/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import com.android.io.CancellableFileIo;
import com.android.prefs.AbstractAndroidLocationsKt;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.Global;
import com.android.prefs.PathLocator;
import com.android.prefs.QueryResult;
import com.android.prefs.VariableType;
import com.android.prefs.VariableValue;
import com.android.utils.EnvironmentProvider;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ!\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0011H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000eH\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/android/prefs/PathLocator;", "", "environmentProvider", "Lcom/android/utils/EnvironmentProvider;", "<init>", "(Lcom/android/utils/EnvironmentProvider;)V", "visitedVariables", "", "Lcom/android/prefs/QueryResult;", "getVisitedVariables", "()Ljava/util/List;", "reset", "", "firstPathOf", "Ljava/nio/file/Path;", "globalVars", "", "Lcom/android/prefs/Global;", "([Lcom/android/prefs/Global;)Ljava/nio/file/Path;", "singlePathOf", "gatherPaths", "", "Lcom/android/prefs/VariableValue;", "handlePath", "globalVar", "path", "queryPath", "queryType", "Lcom/android/prefs/VariableType;", "common"})
@SourceDebugExtension(value={"SMAP\nAbstractAndroidLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAndroidLocations.kt\ncom/android/prefs/PathLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,515:1\n1491#2:516\n1516#2,3:517\n1519#2,3:527\n384#3,7:520\n*S KotlinDebug\n*F\n+ 1 AbstractAndroidLocations.kt\ncom/android/prefs/PathLocator\n*L\n296#1:516\n296#1:517,3\n296#1:527,3\n296#1:520,7\n*E\n"})
class PathLocator {
    @NotNull
    private final EnvironmentProvider environmentProvider;
    @NotNull
    private final List<QueryResult> visitedVariables;

    public PathLocator(@NotNull EnvironmentProvider environmentProvider) {
        Intrinsics.checkNotNullParameter((Object)environmentProvider, (String)"environmentProvider");
        this.environmentProvider = environmentProvider;
        this.visitedVariables = new ArrayList();
    }

    @NotNull
    public final List<QueryResult> getVisitedVariables() {
        return this.visitedVariables;
    }

    public final void reset() {
        this.visitedVariables.clear();
    }

    @Nullable
    public final Path firstPathOf(Global ... globalVars) {
        Intrinsics.checkNotNullParameter((Object)globalVars, (String)"globalVars");
        for (Global globalVar : globalVars) {
            Global[] globalArray = new Global[]{globalVar};
            Path path = this.singlePathOf(globalArray);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Path singlePathOf(Global ... globalVars) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)globalVars, (String)"globalVars");
        List values2 = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])globalVars), (Function1)((Function1)new Function1<Global, List<? extends VariableValue>>(this){
            final /* synthetic */ PathLocator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<VariableValue> invoke(Global it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return PathLocator.access$gatherPaths(this.this$0, it);
            }
        })), (Function1)singlePathOf.values.2.INSTANCE));
        if (values2.isEmpty()) {
            path = null;
        } else if (values2.size() == 1) {
            path = ((VariableValue)CollectionsKt.single((List)values2)).getCorrectPath();
        } else {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = values2;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                VariableValue it = (VariableValue)element$iv$iv;
                boolean bl = false;
                Path key$iv$iv = it.getCorrectPath();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map map = destination$iv$iv;
            if (map.size() == 1) {
                path = (Path)CollectionsKt.single((Iterable)map.keySet());
            } else {
                String message2 = AbstractAndroidLocationsKt.combineLocationValuesIntoMessage$default(values2, "Several environment variables and/or system properties contain different paths to the Android Preferences folder.\nPlease correct and use only one way to inject the preference location.", "It is recommended to use ANDROID_USER_HOME as other methods are deprecated", null, 8, null);
                throw new AndroidLocationsException(message2, null, 2, null);
            }
        }
        return path;
    }

    private final List<VariableValue> gatherPaths(Global $this$gatherPaths) {
        VariableValue sysProp = $this$gatherPaths.isSysProp() ? this.queryPath($this$gatherPaths, VariableType.SYS_PROP) : null;
        VariableValue envVar = $this$gatherPaths.isEnvVar() ? this.queryPath($this$gatherPaths, VariableType.ENV_VAR) : null;
        Object[] objectArray = new VariableValue[]{sysProp, envVar};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Nullable
    protected Path handlePath(@NotNull Global globalVar, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)((Object)globalVar), (String)"globalVar");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return globalVar.getMustExist() && !CancellableFileIo.isDirectory(path, new LinkOption[0]) ? null : path;
    }

    private final VariableValue queryPath(Global globalVar, VariableType queryType) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[queryType.ordinal()]) {
            case 1: {
                string = this.environmentProvider.getSystemProperty(globalVar.getPropName());
                break;
            }
            case 2: {
                string = this.environmentProvider.getEnvVariable(globalVar.getPropName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (string == null) {
            return null;
        }
        String location = string;
        Path path = this.environmentProvider.getFileSystem().getPath(location, new String[0]);
        Intrinsics.checkNotNull((Object)path);
        this.visitedVariables.add(new QueryResult(globalVar, queryType, path));
        Path path2 = this.handlePath(globalVar, path);
        if (path2 == null) {
            return null;
        }
        Path correctPath = path2;
        return new VariableValue(globalVar.getPropName(), queryType, path, correctPath);
    }

    public static final /* synthetic */ List access$gatherPaths(PathLocator $this, Global $receiver) {
        return $this.gatherPaths($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VariableType.values().length];
            try {
                nArray[VariableType.SYS_PROP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VariableType.ENV_VAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

