/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.DomMergeUtils;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.OverrideLibrarySelector;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.Pair;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlDocument {
    private static final String DEFAULT_SDK_VERSION = "1";
    private static final int INVALID_SDK_VERSION = -1;
    private final Element mRootElement;
    private final AtomicReference<XmlElement> mRootNode = new AtomicReference<Object>(null);
    private final SourceFile mSourceFile;
    private final KeyResolver<String> mSelectors;
    private final PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> mSystemPropertyResolver;
    private final Type mType;
    private final String mNamespace;
    private final DocumentModel<ManifestModel.NodeTypes> mModel;
    public Map<Element, NodeOperationType> originalNodeOperation = new HashMap<Element, NodeOperationType>();

    public Pair<Document, Boolean> cloneAndTransform(Predicate<Node> transform, Predicate<Node> shouldRemove) throws ManifestMerger2.MergeFailureException {
        return DomMergeUtils.cloneAndTransform(this.getXml(), transform, shouldRemove);
    }

    public XmlDocument(SourceFile sourceLocation, KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertyResolver, Element element, Type type, String namespace, DocumentModel<ManifestModel.NodeTypes> model) {
        this.mSourceFile = (SourceFile)Preconditions.checkNotNull((Object)sourceLocation);
        this.mRootElement = (Element)Preconditions.checkNotNull((Object)element);
        this.mSelectors = (KeyResolver)Preconditions.checkNotNull(selectors);
        this.mSystemPropertyResolver = (PlaceholderHandler.KeyBasedValueResolver)Preconditions.checkNotNull(systemPropertyResolver);
        this.mType = type;
        this.mNamespace = namespace;
        this.mModel = model;
    }

    public Type getFileType() {
        return this.mType;
    }

    public DocumentModel<ManifestModel.NodeTypes> getModel() {
        return this.mModel;
    }

    public String prettyPrint() {
        return XmlDocument.prettyPrint(this.getXml());
    }

    public static String prettyPrint(Document document) {
        return XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document), null, (boolean)false);
    }

    public Optional<XmlDocument> merge(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReportBuilder, ManifestMerger2.ProcessCancellationChecker processCancellationChecker) {
        return this.merge(lowerPriorityDocument, mergingReportBuilder, true, false, false, processCancellationChecker);
    }

    public Optional<XmlDocument> merge(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReportBuilder, boolean addImplicitPermissions, boolean disableMinSdkVersionCheck, boolean keepGoingOnErrors, ManifestMerger2.ProcessCancellationChecker processCancellationChecker) {
        if (this.getFileType() == Type.MAIN) {
            mergingReportBuilder.getActionRecorder().recordAddedNodeAction(this.getRootNode(), false);
        }
        ImmutableList<KeyAndReason> implicitElements = this.getImplicitElementsToAdd(lowerPriorityDocument, mergingReportBuilder, addImplicitPermissions, disableMinSdkVersionCheck);
        this.getRootNode().mergeWithLowerPriorityNode(lowerPriorityDocument.getRootNode(), mergingReportBuilder, processCancellationChecker);
        this.addImplicitElements(mergingReportBuilder.getActionRecorder(), implicitElements);
        return mergingReportBuilder.hasErrors() && !keepGoingOnErrors ? Optional.empty() : Optional.of(this);
    }

    public KeyResolver<String> getSelectors() {
        return this.mSelectors;
    }

    public PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> getSystemPropertyResolver() {
        return this.mSystemPropertyResolver;
    }

    public Optional<String> compareTo(XmlDocument other) {
        return this.getRootNode().compareTo(other.getRootNode());
    }

    static SourcePosition getNodePosition(XmlNode node) {
        return XmlDocument.getNodePosition(node.getXml());
    }

    static SourcePosition getNodePosition(Node xml) {
        return PositionXmlParser.getPosition((Node)xml);
    }

    public SourceFile getSourceFile() {
        return this.mSourceFile;
    }

    public synchronized void resetRootNode() {
        if (this.mRootNode.get() != null) {
            this.mRootNode.set(new XmlElement(this.mRootElement, this));
        }
    }

    public synchronized XmlElement getRootNode() {
        if (this.mRootNode.get() == null) {
            this.mRootNode.set(new XmlElement(this.mRootElement, this));
        }
        return this.mRootNode.get();
    }

    public Optional<XmlElement> getByTypeAndKey(ManifestModel.NodeTypes type, String keyValue) {
        return this.getRootNode().getNodeByTypeAndKey(type, keyValue);
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getSplitName() {
        return this.mRootElement.getAttribute("split");
    }

    public Optional<XmlAttribute> getPackage() {
        Optional<XmlAttribute> packageAttribute = this.getRootNode().getAttribute(XmlNode.fromXmlName("package"));
        return packageAttribute.isPresent() ? packageAttribute : this.getRootNode().getAttribute(XmlNode.fromNSName("http://schemas.android.com/apk/res/android", "android", "package"));
    }

    public Document getXml() {
        return this.mRootElement.getOwnerDocument();
    }

    private String getExplicitMinSdkVersionOrDefault(MergingReport.Builder mergingReport) {
        String value = this.getExplicitMinSdkVersion(mergingReport);
        return value != null ? value : DEFAULT_SDK_VERSION;
    }

    public String getMinSdkVersion(MergingReport.Builder mergingReport) {
        String injectedMinSdk = this.mSystemPropertyResolver.getValue(ManifestSystemProperty.UsesSdk.MIN_SDK_VERSION);
        if (injectedMinSdk != null) {
            return injectedMinSdk;
        }
        return this.getExplicitMinSdkVersionOrDefault(mergingReport);
    }

    private String getExplicitTargetSdkVersion(MergingReport.Builder mergingReport) {
        return this.getExplicitVersionAttribute("android:targetSdkVersion", mergingReport);
    }

    private String getExplicitMaxSdkVersion(MergingReport.Builder mergingReport) {
        return this.getExplicitVersionAttribute("android:maxSdkVersion", mergingReport);
    }

    private String getExplicitMinSdkVersion(MergingReport.Builder mergingReport) {
        return this.getExplicitVersionAttribute("android:minSdkVersion", mergingReport);
    }

    private String getExplicitVersionAttribute(String attributeName, MergingReport.Builder mergingReport) {
        Optional<XmlAttribute> specifiedVersion;
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (usesSdk.isPresent() && (specifiedVersion = usesSdk.get().getAttribute(XmlNode.fromXmlName(attributeName))).isPresent()) {
            String stringValue = specifiedVersion.get().getValue();
            if (XmlDocument.getApiLevelFromAttribute(stringValue) == -1) {
                String message = String.format("Invalid value for attribute:%1$s, value:%2$s", attributeName, stringValue);
                mergingReport.addMessage(usesSdk.get(), MergingReport.Record.Severity.ERROR, message);
            }
            return stringValue;
        }
        return null;
    }

    private String getRawTargetSdkVersion(MergingReport.Builder mergingReport) {
        String explicitTargetSdkVersion = this.getExplicitTargetSdkVersion(mergingReport);
        if (explicitTargetSdkVersion != null) {
            return explicitTargetSdkVersion;
        }
        return this.getExplicitMinSdkVersionOrDefault(mergingReport);
    }

    public String getTargetSdkVersion(MergingReport.Builder mergingReport) {
        String injectedTargetVersion = this.mSystemPropertyResolver.getValue(ManifestSystemProperty.UsesSdk.TARGET_SDK_VERSION);
        if (injectedTargetVersion != null) {
            return injectedTargetVersion;
        }
        return this.getRawTargetSdkVersion(mergingReport);
    }

    public String getMaxSdkVersion(MergingReport.Builder mergingReport) {
        String injectedMaxVersion = this.mSystemPropertyResolver.getValue(ManifestSystemProperty.UsesSdk.MAX_SDK_VERSION);
        if (injectedMaxVersion != null) {
            return injectedMaxVersion;
        }
        return this.getExplicitMaxSdkVersion(mergingReport);
    }

    boolean checkTopLevelDeclarations(Map<String, Object> placeHolderValues, MergingReport.Builder mergingReportBuilder, Type documentType) {
        Optional<XmlAttribute> mainPackageAttribute = this.getPackage();
        if (!placeHolderValues.containsKey("packageName") && documentType != Type.OVERLAY && !mainPackageAttribute.isPresent()) {
            mergingReportBuilder.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Main AndroidManifest.xml at %1$s manifest:package attribute is not declared", this.getSourceFile().print(true)));
            return false;
        }
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (usesSdk.isPresent()) {
            this.verifyVersion(usesSdk.get(), () -> this.getExplicitMinSdkVersion(mergingReportBuilder), () -> this.getMinSdkVersion(mergingReportBuilder), "minSdkVersion", mergingReportBuilder);
            this.verifyVersion(usesSdk.get(), () -> this.getExplicitTargetSdkVersion(mergingReportBuilder), () -> this.getTargetSdkVersion(mergingReportBuilder), "targetSdkVersion", mergingReportBuilder);
            this.verifyVersion(usesSdk.get(), () -> this.getExplicitMaxSdkVersion(mergingReportBuilder), () -> this.getMaxSdkVersion(mergingReportBuilder), "maxSdkVersion", mergingReportBuilder);
        }
        return true;
    }

    private void verifyVersion(XmlElement usesSdk, Supplier<String> rawValueSupplier, Supplier<String> usedValueSupplier, String propertyName, MergingReport.Builder mergingReportBuilder) {
        String rawValue = rawValueSupplier.get();
        if (rawValue != null && !rawValue.equals(usedValueSupplier.get())) {
            String warning = String.format("uses-sdk:%1$s value (%2$s) specified in the manifest file is ignored. It is overridden by the value declared in the DSL or the variant API, or 1 if not declared/present. Current value is (%3$s).", propertyName, rawValueSupplier.get(), usedValueSupplier.get());
            mergingReportBuilder.addMessage(new SourceFilePosition(this.getSourceFile(), usesSdk.getPosition()), MergingReport.Record.Severity.WARNING, warning);
        }
    }

    private static int getApiLevelFromAttribute(String attributeVersion) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)attributeVersion) ? 1 : 0) != 0);
        if (Character.isDigit(attributeVersion.charAt(0))) {
            try {
                return Integer.parseInt(attributeVersion);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return SdkVersionInfo.getApiByPreviewName((String)attributeVersion, (boolean)true);
    }

    private void addImplicitElements(ActionRecorder actionRecorder, ImmutableList<KeyAndReason> implicitElements) {
        implicitElements.forEach(implicitElement -> this.addIfAbsent(actionRecorder, implicitElement.getKey(), implicitElement.getReason(), new Pair[0]));
    }

    private ImmutableList<KeyAndReason> getImplicitElementsToAdd(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReport, boolean addImplicitPermissions, boolean disableMinSdkVersionCheck) {
        XmlElement usesSdkElement;
        ImmutableList.Builder implicitElementKeys = new ImmutableList.Builder();
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (this.mType == Type.OVERLAY && usesSdk.isEmpty()) {
            return implicitElementKeys.build();
        }
        if (usesSdk.isPresent() && (usesSdkElement = usesSdk.get()).getOperationType() != NodeOperationType.MERGE) {
            mergingReport.addMessage(new SourceFilePosition(this.getSourceFile(), usesSdkElement.getPosition()), MergingReport.Record.Severity.ERROR, "uses-sdk element cannot have a \"tools:node\" attribute");
            return implicitElementKeys.build();
        }
        int thisTargetSdk = XmlDocument.getApiLevelFromAttribute(this.getTargetSdkVersion(mergingReport));
        int libraryTargetSdk = XmlDocument.getApiLevelFromAttribute(lowerPriorityDocument.getFileType() == Type.LIBRARY ? lowerPriorityDocument.getRawTargetSdkVersion(mergingReport) : lowerPriorityDocument.getTargetSdkVersion(mergingReport));
        if (thisTargetSdk == -1 || libraryTargetSdk == -1) {
            return implicitElementKeys.build();
        }
        String libraryTargetSdkVersion = lowerPriorityDocument.getTargetSdkVersion(mergingReport);
        if (!Character.isDigit(libraryTargetSdkVersion.charAt(0)) && !libraryTargetSdkVersion.equals(this.getTargetSdkVersion(mergingReport)) && lowerPriorityDocument.getExplicitTargetSdkVersion(mergingReport) != null) {
            mergingReport.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("uses-sdk:targetSdkVersion %1$s cannot be different than version %2$s declared in library %3$s", this.getTargetSdkVersion(mergingReport), libraryTargetSdkVersion, lowerPriorityDocument.getSourceFile().print(false)));
            return implicitElementKeys.build();
        }
        String libraryMinSdkVersion = lowerPriorityDocument.getExplicitMinSdkVersionOrDefault(mergingReport);
        if (!Character.isDigit(libraryMinSdkVersion.charAt(0)) && !libraryMinSdkVersion.equals(this.getMinSdkVersion(mergingReport))) {
            mergingReport.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("uses-sdk:minSdkVersion %1$s cannot be different than version %2$s declared in library %3$s", this.getMinSdkVersion(mergingReport), libraryMinSdkVersion, lowerPriorityDocument.getSourceFile().print(false)));
            return implicitElementKeys.build();
        }
        if (!disableMinSdkVersionCheck && !this.checkUsesSdkMinVersion(lowerPriorityDocument, mergingReport)) {
            String error = String.format("uses-sdk:minSdkVersion %1$s cannot be smaller than version %2$s declared in library %3$s as the library might be using APIs not available in %1$s\n\tSuggestion: use a compatible library with a minSdk of at most %1$s,\n\t\tor increase this project's minSdk version to at least %2$s,\n\t\tor use tools:overrideLibrary=\"%4$s\" to force usage (may lead to runtime failures)", this.getMinSdkVersion(mergingReport), lowerPriorityDocument.getExplicitMinSdkVersionOrDefault(mergingReport), lowerPriorityDocument.getSourceFile().print(false), lowerPriorityDocument.getNamespace());
            if (usesSdk.isPresent()) {
                mergingReport.addMessage(new SourceFilePosition(this.getSourceFile(), usesSdk.get().getPosition()), MergingReport.Record.Severity.ERROR, error);
            } else {
                mergingReport.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, error);
            }
            return implicitElementKeys.build();
        }
        if (thisTargetSdk <= libraryTargetSdk) {
            return implicitElementKeys.build();
        }
        if (thisTargetSdk < 4) {
            return implicitElementKeys.build();
        }
        if (!addImplicitPermissions) {
            return implicitElementKeys.build();
        }
        boolean hasWriteToExternalStoragePermission = lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_EXTERNAL_STORAGE")).isPresent();
        if (libraryTargetSdk < 4) {
            implicitElementKeys.add((Object)KeyAndReason.of(XmlDocument.permission("WRITE_EXTERNAL_STORAGE"), lowerPriorityDocument.getNamespace() + " has a targetSdkVersion < 4"));
            hasWriteToExternalStoragePermission = true;
            implicitElementKeys.add((Object)KeyAndReason.of(XmlDocument.permission("READ_PHONE_STATE"), lowerPriorityDocument.getNamespace() + " has a targetSdkVersion < 4"));
        }
        if (hasWriteToExternalStoragePermission) {
            implicitElementKeys.add((Object)KeyAndReason.of(XmlDocument.permission("READ_EXTERNAL_STORAGE"), lowerPriorityDocument.getNamespace() + " requested WRITE_EXTERNAL_STORAGE"));
        }
        if (thisTargetSdk >= 16 && libraryTargetSdk < 16) {
            if (lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("READ_CONTACTS")).isPresent()) {
                implicitElementKeys.add((Object)KeyAndReason.of(XmlDocument.permission("READ_CALL_LOG"), lowerPriorityDocument.getNamespace() + " has targetSdkVersion < 16 and requested READ_CONTACTS"));
            }
            if (lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_CONTACTS")).isPresent()) {
                implicitElementKeys.add((Object)KeyAndReason.of(XmlDocument.permission("WRITE_CALL_LOG"), lowerPriorityDocument.getNamespace() + " has targetSdkVersion < 16 and requested WRITE_CONTACTS"));
            }
        }
        return implicitElementKeys.build();
    }

    private boolean checkUsesSdkMinVersion(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReport) {
        int libraryMinSdk;
        int thisMinSdk = XmlDocument.getApiLevelFromAttribute(this.getMinSdkVersion(mergingReport));
        if (thisMinSdk < (libraryMinSdk = XmlDocument.getApiLevelFromAttribute(lowerPriorityDocument.getExplicitMinSdkVersionOrDefault(mergingReport)))) {
            Optional<XmlElement> xmlElementOptional = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
            if (!xmlElementOptional.isPresent()) {
                return false;
            }
            XmlElement xmlElement = xmlElementOptional.get();
            for (OverrideLibrarySelector selector : xmlElement.getOverrideUsesSdkLibrarySelectors()) {
                if (!selector.appliesTo(lowerPriorityDocument.getRootNode())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String permission(String permissionName) {
        return "android.permission." + permissionName;
    }

    @SafeVarargs
    private final void addIfAbsent(ActionRecorder actionRecorder, String keyValue, String reason, Pair<String, String> ... attributes) {
        Optional<XmlElement> xmlElementOptional = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, keyValue);
        if (xmlElementOptional.isPresent()) {
            return;
        }
        Element elementNS = this.getXml().createElement(this.mModel.toXmlName(ManifestModel.NodeTypes.USES_PERMISSION));
        ImmutableList<String> keyAttributesNames = ManifestModel.NodeTypes.USES_PERMISSION.getNodeKeyResolver().getKeyAttributesNames();
        if (keyAttributesNames.size() == 1) {
            elementNS.setAttributeNS("http://schemas.android.com/apk/res/android", "android:" + (String)keyAttributesNames.get(0), keyValue);
        }
        if (attributes != null) {
            for (Pair<String, String> attribute : attributes) {
                elementNS.setAttributeNS("http://schemas.android.com/apk/res/android", "android:" + (String)attribute.getFirst(), (String)attribute.getSecond());
            }
        }
        XmlElement xmlElement = new XmlElement(elementNS, this);
        actionRecorder.recordImpliedNodeAction(xmlElement, reason);
        this.getRootNode().appendChild(elementNS);
    }

    public void clearNodeNamespaces() {
        if (this.clearNodeNamespaces(this.getRootNode().getXml())) {
            this.resetRootNode();
        }
    }

    private boolean clearNodeNamespaces(Element element) {
        String prefix;
        boolean nodeRenamed = false;
        String androidPrefix = XmlUtils.lookupNamespacePrefix((Node)element, (String)"http://schemas.android.com/apk/res/android");
        String name = element.getNodeName();
        int colonIdx = name.indexOf(58);
        if (colonIdx != -1 && (prefix = name.substring(0, colonIdx)).equals(androidPrefix)) {
            String newName = name.substring(colonIdx + 1);
            this.getXml().renameNode(element, null, newName);
            nodeRenamed = true;
        }
        NodeList childrenNodeList = element.getChildNodes();
        for (int i = 0; i < childrenNodeList.getLength(); ++i) {
            Node n = childrenNodeList.item(i);
            if (!(n instanceof Element)) continue;
            nodeRenamed = nodeRenamed || this.clearNodeNamespaces((Element)n);
        }
        return nodeRenamed;
    }

    public static enum Type {
        OVERLAY,
        MAIN,
        LIBRARY;

    }

    private static class KeyAndReason {
        private final String mKey;
        private final String mReason;

        private KeyAndReason(String key, String reason) {
            this.mKey = key;
            this.mReason = reason;
        }

        public static KeyAndReason of(String key, String reason) {
            return new KeyAndReason(key, reason);
        }

        public String getKey() {
            return this.mKey;
        }

        public String getReason() {
            return this.mReason;
        }
    }
}

