/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.MavenCoordinates;
import com.android.build.gradle.internal.dsl.ModulePropertyKey;
import com.android.build.gradle.internal.fusedlibrary.FusedLibraryInternalArtifactType;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkInternalArtifactType;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkVariantScope;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.PrivacySandboxSdkGenerateJarStubsTask;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@BuildAnalyzer(primaryTaskCategory=TaskCategory.METADATA)
@DisableCachingByDefault
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apiPackager", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getApiPackager", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "mergedClasses", "getMergedClasses", "mergedJavaResources", "Lorg/gradle/api/file/RegularFileProperty;", "getMergedJavaResources", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJar", "getOutputJar", "sourceDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getSourceDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "Companion", "CreationAction", "PrivacySandboxApiPackager", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nPrivacySandboxSdkGenerateJarStubsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivacySandboxSdkGenerateJarStubsTask.kt\ncom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,178:1\n32#2,2:179\n1549#3:181\n1620#3,3:182\n37#4,2:185\n*S KotlinDebug\n*F\n+ 1 PrivacySandboxSdkGenerateJarStubsTask.kt\ncom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask\n*L\n82#1:179,2\n92#1:181\n92#1:182,3\n92#1:185,2\n*E\n"})
public abstract class PrivacySandboxSdkGenerateJarStubsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String privacySandboxSdkStubJarFilename = "sdk-interface-descriptors.jar";

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getMergedClasses();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getMergedJavaResources();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getApiPackager();

    @Internal
    @NotNull
    public abstract DirectoryProperty getSourceDirectory();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void doTaskAction() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Object $this$forEach$iv;
        File sourcesDir = ((Directory)this.getSourceDirectory().get()).getAsFile();
        FileUtils.cleanOutputDir((File)sourcesDir);
        FileUtils.copyDirectory((File)this.getMergedClasses().getSingleFile(), (File)sourcesDir);
        Closeable closeable = new ZipFile(((RegularFile)this.getMergedJavaResources().get()).getAsFile());
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            Iterator<? extends ZipEntry> iterator2 = zip.entries().asIterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"zip.entries().asIterator()");
            $this$forEach$iv = iterator2;
            boolean $i$f$forEach = false;
            Iterator<? extends ZipEntry> iterator3 = $this$forEach$iv;
            while (iterator3.hasNext()) {
                ZipEntry element$iv;
                ZipEntry entry = element$iv = iterator3.next();
                boolean bl2 = false;
                byte[] entryBytes = zip.getInputStream(entry).readAllBytes();
                String[] stringArray = new String[]{entry.getName()};
                File candidateFile = FileUtils.join((File)sourcesDir, (String[])stringArray);
                FileUtils.createFile((File)candidateFile, (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)candidateFile, (String)"candidateFile");
                Intrinsics.checkNotNullExpressionValue((Object)entryBytes, (String)"entryBytes");
                FilesKt.writeBytes((File)candidateFile, (byte[])entryBytes);
            }
            zip = Unit.INSTANCE;
        }
        catch (Throwable zip) {
            throwable = zip;
            throw zip;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FileUtils.deleteIfExists((File)((RegularFile)this.getOutputJar().get()).getAsFile());
        File outJar = ((RegularFile)this.getOutputJar().get()).getAsFile();
        Set set = this.getApiPackager().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"apiPackager.files");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        $this$forEach$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File bl2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] apiPackager = thisCollection$iv.toArray(new URL[0]);
        if (apiPackager.length == 0) {
            throw new RuntimeException("No libraries specified for packaging sandbox APIs.");
        }
        Closeable closeable2 = new URLClassLoader(apiPackager);
        Throwable throwable2 = null;
        try {
            URLClassLoader it = (URLClassLoader)closeable2;
            boolean bl = false;
            PrivacySandboxApiPackager privacySandboxApiPackager = new PrivacySandboxApiPackager(it);
            Path path = sourcesDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"sourcesDir.toPath()");
            Path path2 = outJar.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outJar.toPath()");
            privacySandboxApiPackager.packageSdkDescriptors(path, path2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask$Companion;", "", "()V", "privacySandboxSdkStubJarFilename", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask;", "creationConfig", "Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;", "(Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;)V", "getCreationConfig", "()Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nPrivacySandboxSdkGenerateJarStubsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivacySandboxSdkGenerateJarStubsTask.kt\ncom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask$CreationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1549#2:179\n1620#2,3:180\n*S KotlinDebug\n*F\n+ 1 PrivacySandboxSdkGenerateJarStubsTask.kt\ncom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask$CreationAction\n*L\n136#1:179\n136#1:180,3\n*E\n"})
    public static final class CreationAction
    extends TaskCreationAction<PrivacySandboxSdkGenerateJarStubsTask> {
        @NotNull
        private final PrivacySandboxSdkVariantScope creationConfig;

        public CreationAction(@NotNull PrivacySandboxSdkVariantScope creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.creationConfig = creationConfig;
        }

        @NotNull
        public final PrivacySandboxSdkVariantScope getCreationConfig() {
            return this.creationConfig;
        }

        @Override
        @NotNull
        public String getName() {
            return "privacySandboxClassesJarStubs";
        }

        @Override
        @NotNull
        public Class<PrivacySandboxSdkGenerateJarStubsTask> getType() {
            return PrivacySandboxSdkGenerateJarStubsTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PrivacySandboxSdkGenerateJarStubsTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName(PrivacySandboxSdkGenerateJarStubsTask.privacySandboxSdkStubJarFilename).on(PrivacySandboxSdkInternalArtifactType.STUB_JAR.INSTANCE);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).on(PrivacySandboxSdkInternalArtifactType.API_PACKAGER_SOURCES.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void configure(@NotNull PrivacySandboxSdkGenerateJarStubsTask task) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
            MapProperty<String, Object> experimentalProperties = this.creationConfig.getExperimentalProperties();
            experimentalProperties.finalizeValue();
            Object object = experimentalProperties.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"experimentalProperties.get()");
            Object object2 = ModulePropertyKey.Dependencies.ANDROID_PRIVACY_SANDBOX_SDK_API_PACKAGER.getValue((Map)object);
            if (object2 == null) {
                void $this$mapTo$iv$iv;
                String[] stringArray;
                List list;
                objectArray = this.creationConfig.getServices().getProjectOptions().get(StringOption.ANDROID_PRIVACY_SANDBOX_SDK_API_PACKAGER);
                Iterable $this$map$iv = objectArray != null && (list = StringsKt.split$default((CharSequence)((CharSequence)objectArray), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null ? list : CollectionsKt.listOf((Object)MavenCoordinates.ANDROIDX_PRIVACYSANDBOX_TOOLS_TOOLS_APIPACKAGER.toString());
                boolean $i$f$map = false;
                stringArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.creationConfig.getServices().getDependencies().create((Object)it));
                }
                object2 = (List)destination$iv$iv;
            }
            Object apiPackagerDependencies = object2;
            Configuration apiPackager = this.creationConfig.getServices().getConfigurations().detachedConfiguration(new Dependency[0]);
            apiPackager.setCanBeConsumed(false);
            apiPackager.setCanBeResolved(true);
            apiPackager.getDependencies().addAll((Collection)apiPackagerDependencies);
            task.getApiPackager().setFrom((Iterable)apiPackager.getFiles());
            objectArray = new Object[]{this.creationConfig.getArtifacts().get(FusedLibraryInternalArtifactType.MERGED_CLASSES.INSTANCE)};
            HasConfigurableValuesKt.fromDisallowChanges(task.getMergedClasses(), objectArray);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getMergedJavaResources(), this.creationConfig.getArtifacts().get(FusedLibraryInternalArtifactType.MERGED_JAVA_RES.INSTANCE));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0002\b\u0003 \u000b*\b\u0012\u0002\b\u0003\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/PrivacySandboxSdkGenerateJarStubsTask$PrivacySandboxApiPackager;", "", "classLoader", "Ljava/net/URLClassLoader;", "(Ljava/net/URLClassLoader;)V", "apiPackagerPackage", "", "getClassLoader", "()Ljava/net/URLClassLoader;", "packageSdkDescriptorsMethod", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "privacySandboxApiPackagerClass", "Ljava/lang/Class;", "privacySandboxSdkPackager", "packageSdkDescriptors", "", "sdkClasspath", "Ljava/nio/file/Path;", "outputPath", "gradle-core"})
    public static final class PrivacySandboxApiPackager {
        @NotNull
        private final URLClassLoader classLoader;
        @NotNull
        private final String apiPackagerPackage;
        private final Class<?> privacySandboxApiPackagerClass;
        private final Object privacySandboxSdkPackager;
        private final Method packageSdkDescriptorsMethod;

        public PrivacySandboxApiPackager(@NotNull URLClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            this.classLoader = classLoader;
            this.apiPackagerPackage = "androidx.privacysandbox.tools.apipackager";
            this.privacySandboxApiPackagerClass = this.classLoader.loadClass(this.apiPackagerPackage + ".PrivacySandboxApiPackager");
            this.privacySandboxSdkPackager = this.privacySandboxApiPackagerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class[] classArray = new Class[]{Path.class, Path.class};
            this.packageSdkDescriptorsMethod = this.privacySandboxApiPackagerClass.getMethod("packageSdkDescriptors", classArray);
        }

        @NotNull
        public final URLClassLoader getClassLoader() {
            return this.classLoader;
        }

        public final void packageSdkDescriptors(@NotNull Path sdkClasspath, @NotNull Path outputPath) {
            Intrinsics.checkNotNullParameter((Object)sdkClasspath, (String)"sdkClasspath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            Object[] objectArray = new Object[]{sdkClasspath, outputPath};
            this.packageSdkDescriptorsMethod.invoke(this.privacySandboxSdkPackager, objectArray);
        }
    }
}

