/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.GenerateRuntimeEnabledSdkTableTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.splitters.RuntimeEnabledSdkTableInjector;
import com.google.common.collect.ImmutableCollection;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "runtimeConfigFile", "Lorg/gradle/api/file/RegularFileProperty;", "getRuntimeConfigFile", "()Lorg/gradle/api/file/RegularFileProperty;", "runtimeEnabledSdkTableFile", "getRuntimeEnabledSdkTableFile", "doTaskAction", "", "generateRuntimeEnabledSdkTableBytes", "", "runtimeEnabledSdkTables", "", "Lcom/android/bundle/RuntimeEnabledSdkConfigProto$RuntimeEnabledSdk;", "writeRuntimeEnabledSdkTableFromRuntimeConfig", "runtimeConfig", "Ljava/io/File;", "runtimeEnabledSdkTableOutput", "Companion", "CreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nGenerateRuntimeEnabledSdkTableTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateRuntimeEnabledSdkTableTask.kt\ncom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public abstract class GenerateRuntimeEnabledSdkTableTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RUNTIME_ENABLED_SDK_TABLE_FILE_NAME = "RuntimeEnabledSdkTable.xml";

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getRuntimeConfigFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getRuntimeEnabledSdkTableFile();

    @Override
    protected void doTaskAction() {
        File file = ((RegularFile)this.getRuntimeConfigFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"runtimeConfigFile.get().asFile");
        this.writeRuntimeEnabledSdkTableFromRuntimeConfig(file, this.getRuntimeEnabledSdkTableFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeRuntimeEnabledSdkTableFromRuntimeConfig(File runtimeConfig, RegularFileProperty runtimeEnabledSdkTableOutput) {
        RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig runtimeEnabledSdkConfig;
        Closeable closeable = new FileInputStream(runtimeConfig);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream input = (BufferedInputStream)closeable;
            boolean bl = false;
            runtimeEnabledSdkConfig = RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig.parseFrom((InputStream)input);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig privacySandboxRuntimeConfig = runtimeEnabledSdkConfig;
        File file = ((RegularFile)runtimeEnabledSdkTableOutput.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"runtimeEnabledSdkTableOutput.get().asFile");
        List list = privacySandboxRuntimeConfig.getRuntimeEnabledSdkList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"privacySandboxRuntimeConfig.runtimeEnabledSdkList");
        FilesKt.writeBytes((File)file, (byte[])this.generateRuntimeEnabledSdkTableBytes(list));
    }

    private final byte[] generateRuntimeEnabledSdkTableBytes(List<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdkTables) {
        byte[] byArray = RuntimeEnabledSdkTableInjector.generateRuntimeEnabledSdkTableBytes((ImmutableCollection)((ImmutableCollection)GuavaKtxKt.toImmutableList((Iterable)runtimeEnabledSdkTables)));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"generateRuntimeEnabledSd\u2026Tables.toImmutableList())");
        return byArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask$Companion;", "", "()V", "RUNTIME_ENABLED_SDK_TABLE_FILE_NAME", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/GenerateRuntimeEnabledSdkTableTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateRuntimeEnabledSdkTableTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("generate", "PrivacySandboxRuntimeEnabledSdkTable");
        }

        @Override
        @NotNull
        public Class<GenerateRuntimeEnabledSdkTableTask> getType() {
            return GenerateRuntimeEnabledSdkTableTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateRuntimeEnabledSdkTableTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName(GenerateRuntimeEnabledSdkTableTask.RUNTIME_ENABLED_SDK_TABLE_FILE_NAME).on(InternalArtifactType.RUNTIME_ENABLED_SDK_TABLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull GenerateRuntimeEnabledSdkTableTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getRuntimeConfigFile(), this.creationConfig.getArtifacts().get(InternalArtifactType.PRIVACY_SANDBOX_SDK_RUNTIME_CONFIG_FILE.INSTANCE));
        }
    }
}

