/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.ide.BuildTypeImpl;
import com.android.build.gradle.internal.ide.SourceProviderContainerImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class BuildTypeContainerImpl
implements BuildTypeContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BuildType buildType;
    private final SourceProvider sourceProvider;
    private final Collection<SourceProviderContainer> extraSourceProviders;

    static BuildTypeContainer create(BuildTypeData<com.android.build.gradle.internal.dsl.BuildType> buildTypeData, boolean includeProdSourceSet, boolean includeAndroidTest, boolean includeUnitTest, Collection<SourceProviderContainer> sourceProviderContainers) {
        DefaultAndroidSourceSet sourceSet2;
        List<SourceProviderContainer> clonedContainers = SourceProviderContainerImpl.cloneCollection(sourceProviderContainers);
        if (includeAndroidTest && (sourceSet2 = buildTypeData.getSourceSet((ComponentType)ComponentTypeImpl.ANDROID_TEST)) != null) {
            clonedContainers.add(SourceProviderContainerImpl.create(ComponentTypeImpl.ANDROID_TEST.getArtifactName(), sourceSet2));
        }
        if (includeUnitTest && (sourceSet2 = buildTypeData.getSourceSet((ComponentType)ComponentTypeImpl.UNIT_TEST)) != null) {
            clonedContainers.add(SourceProviderContainerImpl.create(ComponentTypeImpl.UNIT_TEST.getArtifactName(), sourceSet2));
        }
        SourceProviderImpl prodSourceSet = null;
        if (includeProdSourceSet) {
            prodSourceSet = new SourceProviderImpl(buildTypeData.getSourceSet());
        }
        return new BuildTypeContainerImpl(new BuildTypeImpl(buildTypeData.getBuildType()), prodSourceSet, clonedContainers);
    }

    private BuildTypeContainerImpl(BuildTypeImpl buildType, SourceProviderImpl sourceProvider, Collection<SourceProviderContainer> extraSourceProviders) {
        this.buildType = buildType;
        this.sourceProvider = sourceProvider;
        this.extraSourceProviders = extraSourceProviders;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.extraSourceProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTypeContainerImpl that = (BuildTypeContainerImpl)o;
        return Objects.equals(this.buildType, that.buildType) && Objects.equals(this.sourceProvider, that.sourceProvider) && Objects.equals(this.extraSourceProviders, that.extraSourceProviders);
    }

    public int hashCode() {
        return Objects.hash(this.buildType, this.sourceProvider, this.extraSourceProviders);
    }
}

