/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.features.InstrumentationCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ClassesHierarchyBuildService;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.FixStackFramesDelegate;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.InstrumentationTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.InstrumentationTaskCreationActionImpl;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.COMPILED_CLASSES, secondaryTaskCategories={TaskCategory.SOURCE_PROCESSING})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/tasks/RecalculateStackFramesTask;", "Lcom/android/build/gradle/internal/tasks/NewIncrementalTask;", "<init>", "()V", "classesInputDir", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassesInputDir", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "jarsInputDir", "getJarsInputDir", "bootClasspath", "getBootClasspath", "referencedClasses", "getReferencedClasses", "classesOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getClassesOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "jarsOutputDir", "getJarsOutputDir", "classesHierarchyBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/ClassesHierarchyBuildService;", "getClassesHierarchyBuildService", "()Lorg/gradle/api/provider/Property;", "createDelegate", "Lcom/android/build/gradle/internal/tasks/FixStackFramesDelegate;", "doTaskAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "CreationAction", "gradle-core"})
public abstract class RecalculateStackFramesTask
extends NewIncrementalTask {
    @Classpath
    @Incremental
    @NotNull
    public abstract ConfigurableFileCollection getClassesInputDir();

    @Classpath
    @Incremental
    @NotNull
    public abstract ConfigurableFileCollection getJarsInputDir();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getReferencedClasses();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getClassesOutputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getJarsOutputDir();

    @Internal
    @NotNull
    public abstract Property<ClassesHierarchyBuildService> getClassesHierarchyBuildService();

    private final FixStackFramesDelegate createDelegate() {
        File file = this.getClassesInputDir().getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSingleFile(...)");
        File file2 = this.getJarsInputDir().isEmpty() ? null : this.getJarsInputDir().getSingleFile();
        Set set = this.getBootClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        Set set2 = this.getReferencedClasses().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
        File file3 = ((Directory)this.getClassesOutputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
        File file4 = ((Directory)this.getJarsOutputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getAsFile(...)");
        return new FixStackFramesDelegate(file, file2, set, set2, file3, file4, this.getWorkerExecutor(), this, (Provider<ClassesHierarchyBuildService>)((Provider)this.getClassesHierarchyBuildService()));
    }

    @Override
    public void doTaskAction(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        if (inputChanges.isIncremental()) {
            FixStackFramesDelegate fixStackFramesDelegate = this.createDelegate();
            Iterable iterable = inputChanges.getFileChanges((FileCollection)this.getJarsInputDir());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
            Iterable iterable2 = inputChanges.getFileChanges((FileCollection)this.getClassesInputDir());
            Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"getFileChanges(...)");
            fixStackFramesDelegate.doIncrementalRun(iterable, iterable2);
        } else {
            this.createDelegate().doFullRun();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0013\u001a\u00020\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/RecalculateStackFramesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/RecalculateStackFramesTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "Lcom/android/build/gradle/internal/tasks/factory/features/InstrumentationTaskCreationAction;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "instrumentationCreationConfig", "Lcom/android/build/gradle/internal/component/features/InstrumentationCreationConfig;", "getInstrumentationCreationConfig", "()Lcom/android/build/gradle/internal/component/features/InstrumentationCreationConfig;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nRecalculateStackFramesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecalculateStackFramesTask.kt\ncom/android/build/gradle/internal/tasks/RecalculateStackFramesTask$CreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,133:1\n78#2:134\n*S KotlinDebug\n*F\n+ 1 RecalculateStackFramesTask.kt\ncom/android/build/gradle/internal/tasks/RecalculateStackFramesTask$CreationAction\n*L\n128#1:134\n*E\n"})
    public static final class CreationAction
    extends VariantTaskCreationAction<RecalculateStackFramesTask, ComponentCreationConfig>
    implements InstrumentationTaskCreationAction {
        private final /* synthetic */ InstrumentationTaskCreationActionImpl $$delegate_0;
        @NotNull
        private final String name;
        @NotNull
        private final Class<RecalculateStackFramesTask> type;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.$$delegate_0 = new InstrumentationTaskCreationActionImpl(creationConfig);
            this.name = this.computeTaskName("fixInstrumented", "ClassesStackFrames");
            this.type = RecalculateStackFramesTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<RecalculateStackFramesTask> getType() {
            return this.type;
        }

        @Override
        public void configure(@NotNull RecalculateStackFramesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{this.creationConfig.getGlobal().getBootClasspath()};
            task.getBootClasspath().from(objectArray).disallowChanges();
            objectArray = new Object[]{this.creationConfig.getProvidedOnlyClasspath()};
            ConfigurableFileCollection configurableFileCollection = task.getReferencedClasses().from(objectArray);
            objectArray = new Object[]{this.getInstrumentationCreationConfig().getDependenciesClassesJarsPostInstrumentation(AndroidArtifacts.ArtifactScope.ALL)};
            configurableFileCollection.from(objectArray).disallowChanges();
            BuildServiceRegistry buildServiceRegistry$iv = this.creationConfig.getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getClassesHierarchyBuildService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, ClassesHierarchyBuildService.class));
        }

        @Override
        @NotNull
        public InstrumentationCreationConfig getInstrumentationCreationConfig() {
            return this.$$delegate_0.getInstrumentationCreationConfig();
        }
    }
}

