/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.dsl.Device;
import com.android.build.api.dsl.EmulatorControl;
import com.android.build.api.instrumentation.StaticTestData;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.DeviceTestCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.component.features.BuildConfigCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestsAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.testing.utp.EmulatorControlConfig;
import com.android.build.gradle.internal.testing.utp.EmulatorControlConfigKt;
import com.android.build.gradle.internal.testing.utp.ManagedDeviceTestRunner;
import com.android.build.gradle.internal.testing.utp.UtpDependencies;
import com.android.build.gradle.internal.testing.utp.UtpDependencyUtilsKt;
import com.android.build.gradle.internal.testing.utp.UtpRunProfileManager;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.model.TestOptions;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u000278B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010'\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0018H\u0016J\b\u0010+\u001a\u00020,H'J\b\u0010-\u001a\u00020,H'J\b\u0010.\u001a\u00020,H'J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180\nH'J\b\u00100\u001a\u00020,H'J\b\u00103\u001a\u00020\u0014H'J\u0010\u00104\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J\b\u00105\u001a\u00020)H\u0016J\b\u00106\u001a\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\rR\u0014\u0010!\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016R\u0014\u0010#\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016R\u0014\u0010%\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0016R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\r\u00a8\u00069"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lcom/android/build/gradle/internal/tasks/AndroidTestTask;", "<init>", "()V", "testRunnerFactory", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "getTestRunnerFactory", "()Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "testData", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/testing/TestData;", "getTestData", "()Lorg/gradle/api/provider/Property;", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "buddyApks", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBuddyApks", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "shouldIgnore", "", "value", "Lorg/gradle/api/artifacts/ArtifactCollection;", "dependencies", "getDependencies", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "device", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "getDevice", "classes", "getClasses", "buildConfigClasses", "getBuildConfigClasses", "rClasses", "getRClasses", "getIgnoreFailures", "setIgnoreFailures", "", "ignore", "getResultsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportsDir", "getCoverageDirectory", "getAdditionalTestOutputEnabled", "getAdditionalTestOutputDir", "enableEmulatorDisplay", "getEnableEmulatorDisplay", "getPrivacySandboxSdkApksFiles", "setDisplayEmulatorOption", "doTaskAction", "testsFound", "TestRunnerFactory", "CreationAction", "gradle-core"})
public abstract class ManagedDeviceInstrumentationTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private boolean shouldIgnore;
    private ArtifactCollection dependencies;

    @Nested
    @NotNull
    public abstract TestRunnerFactory getTestRunnerFactory();

    @Nested
    @NotNull
    public abstract Property<TestData> getTestData();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getInstallOptions();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getBuddyApks();

    @Internal
    @VisibleForTesting
    @NotNull
    public final ArtifactCollection getDependencies() {
        ArtifactCollection artifactCollection = this.dependencies;
        if (artifactCollection != null) {
            return artifactCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        return null;
    }

    @Nested
    @NotNull
    public abstract Property<ManagedVirtualDevice> getDevice();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getBuildConfigClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getRClasses();

    public boolean getIgnoreFailures() {
        return this.shouldIgnore;
    }

    public void setIgnoreFailures(boolean ignore) {
        this.shouldIgnore = ignore;
    }

    @Override
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResultsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCoverageDirectory();

    @Input
    @NotNull
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableEmulatorDisplay();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getPrivacySandboxSdkApksFiles();

    @Option(option="enable-display", description="Adding this option will display the emulator while testing, insteadof running the tests on a headless emulator.")
    public final void setDisplayEmulatorOption(boolean value) {
        this.getEnableEmulatorDisplay().set((Object)value);
    }

    @Override
    public void doTaskAction() {
        boolean bl;
        File file;
        ManagedVirtualDevice device = (ManagedVirtualDevice)this.getDevice().get();
        DeviceProviderInstrumentTestTask.checkForNonApks(this.getBuddyApks().getFiles(), doTaskAction.1.INSTANCE);
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        File codeCoverageOutDir = ((Directory)this.getCoverageDirectory().get()).getAsFile();
        FileUtils.cleanOutputDir((File)codeCoverageOutDir);
        if (((Boolean)this.getAdditionalTestOutputEnabled().get()).booleanValue()) {
            File file2;
            File it = file2 = ((Directory)this.getAdditionalTestOutputDir().get()).getAsFile();
            boolean bl2 = false;
            FileUtils.cleanOutputDir((File)it);
            file = file2;
        } else {
            file = null;
        }
        File additionalTestOutputDir = file;
        UtpRunProfileManager utpRunProfileManager = new UtpRunProfileManager(null, 1, null);
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            bl = true;
        } else {
            boolean bl3;
            ManagedDeviceTestRunner runner = this.getTestRunnerFactory().createTestRunner(this.getWorkerExecutor(), (Integer)this.getTestRunnerFactory().getTestShardsSize().getOrNull(), utpRunProfileManager);
            try {
                Intrinsics.checkNotNull((Object)device);
                Device device2 = (Device)device;
                String string = this.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Intrinsics.checkNotNull((Object)resultsOutDir);
                Intrinsics.checkNotNull((Object)codeCoverageOutDir);
                Object object = this.getProjectPath().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String string2 = (String)object;
                Object object2 = ((TestData)this.getTestData().get()).getFlavorName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                String string3 = (String)object2;
                StaticTestData staticTestData = ((TestData)this.getTestData().get()).getAsStaticData();
                Object object3 = this.getInstallOptions().getOrElse((Object)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getOrElse(...)");
                List list = (List)object3;
                Set set = this.getBuddyApks().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                Logger logger = this.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                Object object4 = this.getPrivacySandboxSdkApksFiles();
                if (object4 == null || (object4 = object4.getFiles()) == null) {
                    object4 = SetsKt.emptySet();
                }
                bl3 = runner.runTests(device2, string, resultsOutDir, codeCoverageOutDir, additionalTestOutputDir, string2, string3, staticTestData, list, set, logger, (Set<? extends File>)object4);
            }
            catch (Exception e) {
                ArtifactCollection artifactCollection = this.getDependencies();
                Object object = this.getTestRunnerFactory().getExecutionEnum().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                TestOptions.Execution execution = (TestOptions.Execution)object;
                Object object5 = this.getAnalyticsService().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                TestsAnalytics.recordCrashedInstrumentedTestRun(artifactCollection, execution, false, (AnalyticsService)object5, utpRunProfileManager);
                throw e;
            }
            bl = bl3;
        }
        boolean success2 = bl;
        File reportOutDir = ((Directory)this.getReportsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        CompositeTestResults results2 = report.generateReport();
        ArtifactCollection artifactCollection = this.getDependencies();
        Object object = this.getTestRunnerFactory().getExecutionEnum().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        TestOptions.Execution execution = (TestOptions.Execution)object;
        int n = results2.getTestCount();
        Object object6 = this.getAnalyticsService().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        TestsAnalytics.recordOkInstrumentedTestRun(artifactCollection, execution, false, n, (AnalyticsService)object6, utpRunProfileManager);
        if (!success2) {
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message2);
                return;
            }
            throw new GradleException(message2);
        }
    }

    private final boolean testsFound() {
        Object object = ((TestData)this.getTestData().get()).hasTests((FileCollection)this.getClasses(), (FileCollection)this.getRClasses(), (FileCollection)this.getBuildConfigClasses()).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BI\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;", "creationConfig", "device", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "testData", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "testResultOutputDir", "Ljava/io/File;", "testReportOutputDir", "additionalTestOutputDir", "coverageOutputDir", "nameSuffix", "", "<init>", "(Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nManagedDeviceInstrumentationTestTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedDeviceInstrumentationTestTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,557:1\n78#2:558\n*S KotlinDebug\n*F\n+ 1 ManagedDeviceInstrumentationTestTask.kt\ncom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction\n*L\n443#1:558\n*E\n"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ManagedDeviceInstrumentationTestTask, InstrumentedTestCreationConfig> {
        @NotNull
        private final ManagedVirtualDevice device;
        @NotNull
        private final AbstractTestDataImpl testData;
        @NotNull
        private final File testResultOutputDir;
        @NotNull
        private final File testReportOutputDir;
        @NotNull
        private final File additionalTestOutputDir;
        @NotNull
        private final File coverageOutputDir;
        @NotNull
        private final String name;
        @NotNull
        private final Class<ManagedDeviceInstrumentationTestTask> type;

        public CreationAction(@NotNull InstrumentedTestCreationConfig creationConfig, @NotNull ManagedVirtualDevice device, @NotNull AbstractTestDataImpl testData, @NotNull File testResultOutputDir, @NotNull File testReportOutputDir, @NotNull File additionalTestOutputDir, @NotNull File coverageOutputDir, @NotNull String nameSuffix) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
            Intrinsics.checkNotNullParameter((Object)testResultOutputDir, (String)"testResultOutputDir");
            Intrinsics.checkNotNullParameter((Object)testReportOutputDir, (String)"testReportOutputDir");
            Intrinsics.checkNotNullParameter((Object)additionalTestOutputDir, (String)"additionalTestOutputDir");
            Intrinsics.checkNotNullParameter((Object)coverageOutputDir, (String)"coverageOutputDir");
            Intrinsics.checkNotNullParameter((Object)nameSuffix, (String)"nameSuffix");
            super(creationConfig, false, 2, null);
            this.device = device;
            this.testData = testData;
            this.testResultOutputDir = testResultOutputDir;
            this.testReportOutputDir = testReportOutputDir;
            this.additionalTestOutputDir = additionalTestOutputDir;
            this.coverageOutputDir = coverageOutputDir;
            this.name = this.computeTaskName(this.device.getName(), nameSuffix);
            this.type = ManagedDeviceInstrumentationTestTask.class;
        }

        public /* synthetic */ CreationAction(InstrumentedTestCreationConfig instrumentedTestCreationConfig, ManagedVirtualDevice managedVirtualDevice, AbstractTestDataImpl abstractTestDataImpl, File file, File file2, File file3, File file4, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x80) != 0) {
                string = "";
            }
            this(instrumentedTestCreationConfig, managedVirtualDevice, abstractTestDataImpl, file, file2, file3, file4, string);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<ManagedDeviceInstrumentationTestTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ManagedDeviceInstrumentationTestTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.1.INSTANCE).atLocation(this.coverageOutputDir.getAbsolutePath()).on(InternalArtifactType.MANAGED_DEVICE_CODE_COVERAGE.INSTANCE);
            boolean isAdditionalAndroidTestOutputEnabled = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (isAdditionalAndroidTestOutputEnabled) {
                ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.2.INSTANCE).atLocation(this.additionalTestOutputDir.getAbsolutePath()).on(InternalArtifactType.MANAGED_DEVICE_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
            }
            UtpDependencyUtilsKt.maybeCreateUtpConfigurations(this.creationConfig);
        }

        @Override
        public void configure(@NotNull ManagedDeviceInstrumentationTestTask task) {
            Object[] objectArray;
            Object it;
            VariantCreationConfig variantCreationConfig;
            RegularFileProperty regularFileProperty;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getEnableEmulatorDisplay().convention((Object)false);
            RegularFileProperty $this$configure_u24lambda_u240 = regularFileProperty = task.getTestRunnerFactory().getJvmExecutable();
            boolean bl = false;
            $this$configure_u24lambda_u240.set(new File(System.getProperty("java.home"), "bin/java"));
            $this$configure_u24lambda_u240.disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getJavaVersion(), JavaVersion.current());
            task.getTestRunnerFactory().getEnableEmulatorDisplay().set((Provider)task.getEnableEmulatorDisplay());
            GlobalTaskCreationConfig globalConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getGlobal();
            ProjectOptions projectOptions = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions();
            ComponentCreationConfig componentCreationConfig = this.creationConfig;
            DeviceTestCreationConfig deviceTestCreationConfig = componentCreationConfig instanceof DeviceTestCreationConfig ? (DeviceTestCreationConfig)componentCreationConfig : null;
            VariantCreationConfig testedConfig = deviceTestCreationConfig != null ? deviceTestCreationConfig.getMainVariant() : null;
            Object object = testedConfig;
            if (object == null || (object = object.getName()) == null) {
                object = ((InstrumentedTestCreationConfig)this.creationConfig).getName();
            }
            Object variantName = object;
            task.setDescription("Installs and runs the test for " + (String)variantName + "  on the managed device " + this.device.getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getDevice(), this.device);
            if (this.device.getSdkVersion() <= 26 && !projectOptions.get(BooleanOption.GRADLE_MANAGED_DEVICE_ALLOW_OLD_API_LEVEL_DEVICES)) {
                throw new GradleException(StringsKt.trimIndent((String)("\n                    API level 26 and lower is currently not supported for Gradle Managed devices.\n                    Your current configuration requires API level " + this.device.getSdkVersion() + ".\n                    While it's not recommended, you can use API levels 26 and lower by adding\n                    android.experimental.testOptions.managedDevices.allowOldApiLevelDevices=true\n                    to your gradle.properties file.\n                    ")));
            }
            BuildServiceRegistry buildServiceRegistry$iv = ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getAvdComponents(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, AvdComponentsBuildService.class));
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getTestData(), this.testData);
            task.getInstallOptions().set((Iterable)globalConfig2.getInstallationOptions().getInstallOptions());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getCompileSdkVersion(), globalConfig2.getCompileSdkHashString());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getBuildToolsRevision(), globalConfig2.getBuildToolsRevision());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getSdkBuildService(), BuildServicesKt.getBuildService(((InstrumentedTestCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getTestShardsSize(), projectOptions.get(IntegerOption.MANAGED_DEVICE_SHARD_POOL_SIZE));
            TestOptions.Execution executionEnum = globalConfig2.getTestOptionExecutionEnum();
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getExecutionEnum(), executionEnum);
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getForceCompilation(), ((InstrumentedTestCreationConfig)this.creationConfig).isForceAotCompilation());
            if (!projectOptions.get(BooleanOption.ANDROID_TEST_USES_UNIFIED_TEST_PLATFORM)) {
                LoggerWrapper.getLogger(CreationAction.class).warning("Implicitly enabling Unified Test Platform because related features are specified in gradle test options. Please add -Pandroid.experimental.androidTest.useUnifiedTestPlatform=true to your gradle command to suppress this warning.", new Object[0]);
            }
            UtpDependencies utpDependencies = task.getTestRunnerFactory().getUtpDependencies();
            ConfigurationContainer configurationContainer = task.getProject().getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
            UtpDependencyUtilsKt.resolveDependencies(utpDependencies, configurationContainer);
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getGetTargetIsSplitApk(), (variantCreationConfig = testedConfig) != null && (variantCreationConfig = variantCreationConfig.getComponentType()) != null ? variantCreationConfig.isDynamicFeature() : false);
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getGetKeepInstalledApks(), projectOptions.get(BooleanOption.ANDROID_TEST_LEAVE_APKS_INSTALLED_AFTER_RUN));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getEmulatorGpuFlag(), ManagedDeviceUtilsKt.computeManagedDeviceEmulatorMode(((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions()));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getShowEmulatorKernelLoggingFlag(), ((InstrumentedTestCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.GRADLE_MANAGED_DEVICE_EMULATOR_SHOW_KERNEL_LOGGING));
            boolean infoLoggingEnabled = Logging.getLogger(ManagedDeviceInstrumentationTestTask.class).isInfoEnabled();
            task.getTestRunnerFactory().getUtpLoggingLevel().set((Object)(infoLoggingEnabled ? Level.INFO : Level.OFF));
            Property<EmulatorControlConfig> property = task.getTestRunnerFactory().getEmulatorControlConfig();
            EmulatorControl emulatorControl = globalConfig2.getAndroidTestOptions().getEmulatorControl();
            Intrinsics.checkNotNull((Object)emulatorControl, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.dsl.EmulatorControl");
            HasConfigurableValuesKt.setDisallowChanges(property, EmulatorControlConfigKt.createEmulatorControlConfig(projectOptions, (com.android.build.gradle.internal.dsl.EmulatorControl)emulatorControl));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getInstallApkTimeout(), projectOptions.get(IntegerOption.INSTALL_APK_TIMEOUT));
            task.dependencies = VariantDependencies.getArtifactCollection$default(((InstrumentedTestCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR, null, 8, null);
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.getResultsDir().set(this.testResultOutputDir);
            task.getReportsDir().set(this.testReportOutputDir);
            Object[] objectArray2 = (Object[])task.getProject().getConfigurations().findByName("androidTestUtil");
            if (objectArray2 != null) {
                it = objectArray2;
                boolean bl2 = false;
                objectArray = new Object[]{it};
                task.getBuddyApks().from(objectArray);
            }
            objectArray2 = new Object[]{((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
            task.getClasses().from(objectArray2);
            task.getClasses().disallowChanges();
            BuildConfigCreationConfig buildConfigCreationConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getBuildConfigCreationConfig();
            if (buildConfigCreationConfig2 != null) {
                it = buildConfigCreationConfig2;
                boolean bl3 = false;
                objectArray = new Object[]{it.getCompiledBuildConfig()};
                task.getBuildConfigClasses().from(objectArray);
            }
            task.getBuildConfigClasses().disallowChanges();
            AndroidResourcesCreationConfig androidResourcesCreationConfig2 = ((InstrumentedTestCreationConfig)this.creationConfig).getAndroidResourcesCreationConfig();
            if (androidResourcesCreationConfig2 != null) {
                it = androidResourcesCreationConfig2;
                boolean bl4 = false;
                objectArray = new Object[]{it.getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH)};
                task.getRClasses().from(objectArray);
            }
            task.getRClasses().disallowChanges();
            if (this.testData.getPrivacySandboxSdkApks() != null) {
                task.getPrivacySandboxSdkApksFiles().setFrom((Iterable)this.testData.getPrivacySandboxSdkApks());
            }
            task.getPrivacySandboxSdkApksFiles().disallowChanges();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u001d2\u0006\u0010=\u001a\u00020>\u00a2\u0006\u0002\u0010?R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\fR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\fR\u0014\u0010%\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\fR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\fR\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\fR\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\fR\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\fR\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\u00110\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\fR\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u00110\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\f\u00a8\u0006@"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "", "<init>", "()V", "jvmExecutable", "Lorg/gradle/api/file/RegularFileProperty;", "getJvmExecutable", "()Lorg/gradle/api/file/RegularFileProperty;", "javaVersion", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/JavaVersion;", "getJavaVersion", "()Lorg/gradle/api/provider/Property;", "executionEnum", "Lcom/android/builder/model/TestOptions$Execution;", "getExecutionEnum", "forceCompilation", "", "getForceCompilation", "emulatorControlConfig", "Lcom/android/build/gradle/internal/testing/utp/EmulatorControlConfig;", "getEmulatorControlConfig", "compileSdkVersion", "", "getCompileSdkVersion", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "testShardsSize", "", "getTestShardsSize", "sdkBuildService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkBuildService", "avdComponents", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdComponents", "utpDependencies", "Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "getUtpDependencies", "()Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "utpLoggingLevel", "Ljava/util/logging/Level;", "getUtpLoggingLevel", "emulatorGpuFlag", "getEmulatorGpuFlag", "showEmulatorKernelLoggingFlag", "getShowEmulatorKernelLoggingFlag", "installApkTimeout", "getInstallApkTimeout", "enableEmulatorDisplay", "getEnableEmulatorDisplay", "getTargetIsSplitApk", "getGetTargetIsSplitApk", "getKeepInstalledApks", "getGetKeepInstalledApks", "createTestRunner", "Lcom/android/build/gradle/internal/testing/utp/ManagedDeviceTestRunner;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "numShards", "utpRunProfileManager", "Lcom/android/build/gradle/internal/testing/utp/UtpRunProfileManager;", "(Lorg/gradle/workers/WorkerExecutor;Ljava/lang/Integer;Lcom/android/build/gradle/internal/testing/utp/UtpRunProfileManager;)Lcom/android/build/gradle/internal/testing/utp/ManagedDeviceTestRunner;", "gradle-core"})
    public static abstract class TestRunnerFactory {
        @Internal
        @NotNull
        public abstract RegularFileProperty getJvmExecutable();

        @Input
        @NotNull
        public abstract Property<JavaVersion> getJavaVersion();

        @Input
        @NotNull
        public abstract Property<TestOptions.Execution> getExecutionEnum();

        @Input
        @NotNull
        public abstract Property<Boolean> getForceCompilation();

        @Input
        @NotNull
        public abstract Property<EmulatorControlConfig> getEmulatorControlConfig();

        @Input
        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @Input
        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @Input
        @Optional
        @NotNull
        public abstract Property<Integer> getTestShardsSize();

        @Internal
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkBuildService();

        @Internal
        @NotNull
        public abstract Property<AvdComponentsBuildService> getAvdComponents();

        @Nested
        @NotNull
        public abstract UtpDependencies getUtpDependencies();

        @Internal
        @NotNull
        public abstract Property<Level> getUtpLoggingLevel();

        @Input
        @NotNull
        public abstract Property<String> getEmulatorGpuFlag();

        @Input
        @NotNull
        public abstract Property<Boolean> getShowEmulatorKernelLoggingFlag();

        @Input
        @Optional
        @NotNull
        public abstract Property<Integer> getInstallApkTimeout();

        @Input
        @NotNull
        public abstract Property<Boolean> getEnableEmulatorDisplay();

        @Input
        @Optional
        @NotNull
        public abstract Property<Boolean> getGetTargetIsSplitApk();

        @Input
        @Optional
        @NotNull
        public abstract Property<Boolean> getGetKeepInstalledApks();

        @NotNull
        public final ManagedDeviceTestRunner createTestRunner(@NotNull WorkerExecutor workerExecutor, @Nullable Integer numShards, @NotNull UtpRunProfileManager utpRunProfileManager) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
            Intrinsics.checkNotNullParameter((Object)utpRunProfileManager, (String)"utpRunProfileManager");
            TestOptions.Execution execution = (TestOptions.Execution)this.getExecutionEnum().get();
            switch (execution == null ? -1 : WhenMappings.$EnumSwitchMapping$0[execution.ordinal()]) {
                case 1: 
                case 2: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean useOrchestrator = bl;
            UtpDependencies utpDependencies = this.getUtpDependencies();
            File file = ((RegularFile)this.getJvmExecutable().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2 = ((SdkComponentsBuildService)this.getSdkBuildService().get()).sdkLoader((Provider<String>)((Provider)this.getCompileSdkVersion()), (Provider<Revision>)((Provider)this.getBuildToolsRevision()));
            Object object = this.getEmulatorControlConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            EmulatorControlConfig emulatorControlConfig = (EmulatorControlConfig)object;
            Object object2 = this.getForceCompilation().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            boolean bl2 = (Boolean)object2;
            Object object3 = this.getEmulatorGpuFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            String string = (String)object3;
            Object object4 = this.getShowEmulatorKernelLoggingFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            boolean bl3 = (Boolean)object4;
            Object object5 = this.getAvdComponents().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
            AvdComponentsBuildService avdComponentsBuildService = (AvdComponentsBuildService)object5;
            Integer n = (Integer)this.getInstallApkTimeout().getOrNull();
            Object object6 = this.getEnableEmulatorDisplay().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            boolean bl4 = (Boolean)object6;
            Object object7 = this.getUtpLoggingLevel().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
            Level level = (Level)object7;
            Object object8 = this.getGetTargetIsSplitApk().getOrElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"getOrElse(...)");
            return new ManagedDeviceTestRunner(workerExecutor, utpDependencies, file, versionedSdkLoader2, emulatorControlConfig, useOrchestrator, bl2, numShards, string, bl3, avdComponentsBuildService, n, bl4, level, (Boolean)object8, (Boolean)this.getGetKeepInstalledApks().get() == false, utpRunProfileManager, null, null, 393216, null);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TestOptions.Execution.values().length];
                try {
                    nArray[TestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

