/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.apksig.apk.ApkUtils;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.tasks.BundleTaskUtil;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.BuildSdkApksCommand;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.android.zipflinger.ZipArchive;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H'J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarToExtractedApksTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/tasks/AsarToExtractedApksTransform$AsarToExtractedApksTransformParameters;", "<init>", "()V", "getInputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "AsarToExtractedApksTransformParameters", "gradle-core"})
public abstract class AsarToExtractedApksTransform
implements TransformAction<AsarToExtractedApksTransformParameters> {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs2) {
        Intrinsics.checkNotNullParameter((Object)outputs2, (String)"outputs");
        Path inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile().toPath();
        Intrinsics.checkNotNull((Object)inputFile);
        Path outputDir = outputs2.dir((Object)PathsKt.getNameWithoutExtension((Path)inputFile)).toPath();
        Path sdkApksFile = outputDir.resolve(PathsKt.getNameWithoutExtension((Path)inputFile) + ".apks");
        Path tempDir = Files.createTempDirectory("asb", new FileAttribute[0]);
        try {
            Path renamedInputFile = tempDir.resolve(StringsKt.substringBeforeLast$default((String)((Object)inputFile.getFileName()).toString(), (char)'.', null, (int)2, null) + ".asb");
            FileUtils.copyFile((Path)inputFile, (Path)renamedInputFile);
            Path aapt2Executable = Aapt2Daemon.getAapt2Executable(((AsarToExtractedApksTransformParameters)this.getParameters()).getAapt2()).toFile().toPath();
            SigningConfigData signingConfigData = (SigningConfigData)((AsarToExtractedApksTransformParameters)this.getParameters()).getSigningConfigData().get();
            BuildSdkApksCommand.Builder builder = BuildSdkApksCommand.builder().setExecutorService(MoreExecutors.listeningDecorator((ExecutorService)((AsarToExtractedApksTransformParameters)this.getParameters()).getWorkerFacade().getExecutor())).setSdkBundlePath(renamedInputFile).setOutputFile(sdkApksFile).setAapt2Command(Aapt2Command.createFromExecutablePath((Path)aapt2Executable));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setAapt2Command(...)");
            Intrinsics.checkNotNull((Object)signingConfigData);
            BuildSdkApksCommand.Builder command = BundleTaskUtil.setSigningConfiguration(builder, signingConfigData).setVersionCode(1).setMinSdkVersion(33);
            command.build().execute();
            Path outputFile = outputDir.resolve("standalone.apk");
            Closeable closeable = (Closeable)new ZipArchive(sdkApksFile);
            Throwable throwable = null;
            try {
                ZipArchive sdkApks = (ZipArchive)closeable;
                boolean bl = false;
                Closeable closeable2 = sdkApks.getInputStream("standalones/standalone.apk");
                Throwable throwable2 = null;
                try {
                    InputStream inputStream = (InputStream)closeable2;
                    boolean bl2 = false;
                    Files.copy(inputStream, outputFile, new CopyOption[0]);
                    Closeable closeable3 = (Closeable)new ZipArchive(outputFile);
                    Throwable throwable3 = null;
                    try {
                        ZipArchive apk = (ZipArchive)closeable3;
                        boolean bl3 = false;
                        Artifact artifact = (Artifact)InternalArtifactType.EXTRACTED_APKS_FROM_PRIVACY_SANDBOX_SDKs.INSTANCE;
                        String string = ApkUtils.getPackageNameFromBinaryAndroidManifest((ByteBuffer)apk.getContent("AndroidManifest.xml"));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageNameFromBinaryAndroidManifest(...)");
                        BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsImpl(0, artifact, string, "", CollectionsKt.listOf((Object)BuiltArtifactImpl.Companion.make$default(BuiltArtifactImpl.Companion, ((Object)outputFile).toString(), null, null, null, null, 30, null)), null, null, null, 225, null);
                        File file = outputDir.toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                        builtArtifactsImpl.saveToDirectory(file);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            PathUtils.deleteRecursivelyIfExists((Path)tempDir);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0014\u0010\u0012\u001a\u00020\u00138WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarToExtractedApksTransform$AsarToExtractedApksTransformParameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "signingConfigData", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "getSigningConfigData", "()Lorg/gradle/api/provider/Property;", "signingConfigValidationResultDir", "Lorg/gradle/api/file/DirectoryProperty;", "getSigningConfigValidationResultDir", "()Lorg/gradle/api/file/DirectoryProperty;", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "getAnalyticsService", "workerFacade", "Lcom/android/ide/common/workers/ExecutorServiceAdapter;", "getWorkerFacade", "()Lcom/android/ide/common/workers/ExecutorServiceAdapter;", "gradle-core"})
    public static interface AsarToExtractedApksTransformParameters
    extends GenericTransformParameters {
        @Nested
        @NotNull
        public Aapt2Input getAapt2();

        @Nested
        @NotNull
        public Property<SigningConfigData> getSigningConfigData();

        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        @NotNull
        public DirectoryProperty getSigningConfigValidationResultDir();

        @Internal
        @NotNull
        public Property<AnalyticsService> getAnalyticsService();

        @Internal
        @NotNull
        default public ExecutorServiceAdapter getWorkerFacade() {
            Object object = this.getAnalyticsService().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return Workers.INSTANCE.withThreads("AsarToExtractedApksTransform", (AnalyticsService)object);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Internal
            @Deprecated
            @NotNull
            public static ExecutorServiceAdapter getWorkerFacade(@NotNull AsarToExtractedApksTransformParameters $this) {
                return $this.getWorkerFacade();
            }
        }
    }
}

