/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.Version;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkInternalArtifactType;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkVariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.AppMetadataTaskKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.AndroidVariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.METADATA)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u00192\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "appMetadataVersion", "Lorg/gradle/api/provider/Property;", "", "getAppMetadataVersion", "()Lorg/gradle/api/provider/Property;", "agpVersion", "getAgpVersion", "agdeVersion", "getAgdeVersion", "doTaskAction", "", "configureTaskInputs", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "CreationAction", "PrivacySandboxSdkCreationAction", "CreationForAssetPackBundleAction", "Companion", "gradle-core"})
public abstract class AppMetadataTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String APP_METADATA_VERSION = "1.1";

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public abstract Property<String> getAppMetadataVersion();

    @Input
    @NotNull
    public abstract Property<String> getAgpVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAgdeVersion();

    @Override
    protected void doTaskAction() {
        File appMetadataFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        FileUtils.deleteIfExists((File)appMetadataFile);
        Files.createParentDirs((File)appMetadataFile);
        Intrinsics.checkNotNull((Object)appMetadataFile);
        Object object = this.getAppMetadataVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getAgpVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        AppMetadataTaskKt.access$writeAppMetadataFile(appMetadataFile, string, (String)object2, (String)this.getAgdeVersion().getOrNull());
    }

    private final void configureTaskInputs(ProjectOptions projectOptions) {
        HasConfigurableValuesKt.setDisallowChanges(this.getAppMetadataVersion(), APP_METADATA_VERSION);
        HasConfigurableValuesKt.setDisallowChanges(this.getAgpVersion(), Version.ANDROID_GRADLE_PLUGIN_VERSION);
        Property<String> property = this.getAgdeVersion();
        Provider<String> provider2 = projectOptions.getProvider(StringOption.IDE_AGDE_VERSION);
        Intrinsics.checkNotNullExpressionValue(provider2, (String)"getProvider(...)");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$Companion;", "", "<init>", "()V", "APP_METADATA_VERSION", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "name", "", "getName", "()Ljava/lang/String;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<AppMetadataTask, ApplicationCreationConfig> {
        @NotNull
        private final Class<AppMetadataTask> type;
        @NotNull
        private final String name;

        public CreationAction(@NotNull ApplicationCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.type = AppMetadataTask.class;
            this.name = this.computeTaskName("write", "AppMetadata");
        }

        @Override
        @NotNull
        public Class<AppMetadataTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AppMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            AppMetadataTaskKt.access$configureTaskOutputs(taskProvider, ((ApplicationCreationConfig)this.creationConfig).getArtifacts());
        }

        @Override
        public void configure(@NotNull AppMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.configureTaskInputs(((ApplicationCreationConfig)this.creationConfig).getServices().getProjectOptions());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$CreationForAssetPackBundleAction;", "Lcom/android/build/gradle/internal/tasks/factory/AndroidVariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "<init>", "(Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lcom/android/build/gradle/options/ProjectOptions;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "name", "", "getName", "()Ljava/lang/String;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationForAssetPackBundleAction
    extends AndroidVariantTaskCreationAction<AppMetadataTask> {
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final ProjectOptions projectOptions;
        @NotNull
        private final Class<AppMetadataTask> type;
        @NotNull
        private final String name;

        public CreationForAssetPackBundleAction(@NotNull ArtifactsImpl artifacts2, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            super(null, 1, null);
            this.artifacts = artifacts2;
            this.projectOptions = projectOptions;
            this.type = AppMetadataTask.class;
            this.name = "writeAppMetadata";
        }

        @Override
        @NotNull
        public Class<AppMetadataTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AppMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            AppMetadataTaskKt.access$configureTaskOutputs(taskProvider, this.artifacts);
        }

        @Override
        public void configure(@NotNull AppMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((AndroidVariantTask)task);
            task.configureTaskInputs(this.projectOptions);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$PrivacySandboxSdkCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/AndroidVariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "creationConfig", "Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;", "<init>", "(Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "name", "", "getName", "()Ljava/lang/String;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class PrivacySandboxSdkCreationAction
    extends AndroidVariantTaskCreationAction<AppMetadataTask> {
        @NotNull
        private final PrivacySandboxSdkVariantScope creationConfig;
        @NotNull
        private final Class<AppMetadataTask> type;
        @NotNull
        private final String name;

        public PrivacySandboxSdkCreationAction(@NotNull PrivacySandboxSdkVariantScope creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(null, 1, null);
            this.creationConfig = creationConfig;
            this.type = AppMetadataTask.class;
            this.name = "writeAppMetadata";
        }

        @Override
        @NotNull
        public Class<AppMetadataTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AppMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("app-metadata.properties").on(PrivacySandboxSdkInternalArtifactType.APP_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull AppMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((AndroidVariantTask)task);
            task.configureTaskInputs(this.creationConfig.getServices().getProjectOptions());
        }
    }
}

