/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.Split;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class SplitOptions
implements Split {
    private final Set<String> values = Sets.newHashSet();
    private final Set<String> allowedValues = Sets.newHashSet();

    protected void init() {
        this.values.addAll(this.getDefaultValues());
        this.allowedValues.addAll((Collection<String>)this.getAllowedValues());
    }

    protected abstract Set<String> getDefaultValues();

    protected abstract ImmutableSet<String> getAllowedValues();

    public void exclude(String ... excludes2) {
        this.values.removeAll(Arrays.asList(excludes2));
    }

    public void include(String ... includes) {
        this.values.addAll(Arrays.asList(includes));
    }

    public void reset() {
        this.values.clear();
    }

    public Set<String> getApplicableFilters() {
        if (!this.isEnable()) {
            return Collections.emptySet();
        }
        HashSet results2 = Sets.newHashSetWithExpectedSize((int)this.values.size());
        for (String value : this.values) {
            if (!this.allowedValues.contains(value)) continue;
            results2.add(value);
        }
        return results2;
    }
}

