/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.core.dsl.impl.DslInfoUtilsKt;
import com.android.build.gradle.internal.variant.DimensionCombination;
import com.android.builder.core.ComponentType;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000f2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0016\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/api/VariantFilter;", "Lcom/android/build/api/variant/VariantFilter;", "readOnlyObjectProvider", "Lcom/android/build/gradle/internal/api/ReadOnlyObjectProvider;", "<init>", "(Lcom/android/build/gradle/internal/api/ReadOnlyObjectProvider;)V", "_dimensionCombination", "Lcom/android/build/gradle/internal/variant/DimensionCombination;", "_defaultConfig", "Lcom/android/builder/model/ProductFlavor;", "_buildType", "Lcom/android/builder/model/BuildType;", "_flavors", "", "_type", "Lcom/android/builder/core/ComponentType;", "_name", "", "reset", "", "dimensionCombination", "defaultConfig", "buildType", "type", "flavors", "ignore", "", "getIgnore", "()Z", "setIgnore", "(Z)V", "getDefaultConfig", "()Lcom/android/builder/model/ProductFlavor;", "getBuildType", "()Lcom/android/builder/model/BuildType;", "getFlavors", "()Ljava/util/List;", "name", "getName", "()Ljava/lang/String;", "gradle-core"})
public final class VariantFilter
implements com.android.build.api.variant.VariantFilter {
    @NotNull
    private final ReadOnlyObjectProvider readOnlyObjectProvider;
    private DimensionCombination _dimensionCombination;
    private ProductFlavor _defaultConfig;
    private BuildType _buildType;
    @Nullable
    private List<? extends ProductFlavor> _flavors;
    private ComponentType _type;
    @Nullable
    private String _name;
    private boolean ignore;

    public VariantFilter(@NotNull ReadOnlyObjectProvider readOnlyObjectProvider) {
        Intrinsics.checkNotNullParameter((Object)readOnlyObjectProvider, (String)"readOnlyObjectProvider");
        this.readOnlyObjectProvider = readOnlyObjectProvider;
    }

    public final void reset(@NotNull DimensionCombination dimensionCombination, @NotNull ProductFlavor defaultConfig, @NotNull BuildType buildType, @NotNull ComponentType type, @Nullable List<? extends ProductFlavor> flavors) {
        Intrinsics.checkNotNullParameter((Object)dimensionCombination, (String)"dimensionCombination");
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.setIgnore(false);
        this._dimensionCombination = dimensionCombination;
        this._defaultConfig = defaultConfig;
        this._buildType = buildType;
        this._flavors = flavors;
        this._type = type;
        this._name = null;
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    @NotNull
    public ProductFlavor getDefaultConfig() {
        ProductFlavor productFlavor = this._defaultConfig;
        if (productFlavor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_defaultConfig");
            productFlavor = null;
        }
        ProductFlavor productFlavor2 = this.readOnlyObjectProvider.getDefaultConfig(productFlavor);
        Intrinsics.checkNotNullExpressionValue((Object)productFlavor2, (String)"getDefaultConfig(...)");
        return productFlavor2;
    }

    @NotNull
    public BuildType getBuildType() {
        BuildType buildType = this._buildType;
        if (buildType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_buildType");
            buildType = null;
        }
        BuildType buildType2 = this.readOnlyObjectProvider.getBuildType(buildType);
        Intrinsics.checkNotNullExpressionValue((Object)buildType2, (String)"getBuildType(...)");
        return buildType2;
    }

    @NotNull
    public List<ProductFlavor> getFlavors() {
        List<? extends ProductFlavor> list = this._flavors;
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<? extends ProductFlavor> fList = list;
        return new ImmutableFlavorList(fList, this.readOnlyObjectProvider);
    }

    @NotNull
    public String getName() {
        String currentName = this._name;
        if (currentName == null) {
            String newName;
            ComponentType componentType;
            DimensionCombination dimensionCombination = this._dimensionCombination;
            if (dimensionCombination == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_dimensionCombination");
                dimensionCombination = null;
            }
            if ((componentType = this._type) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_type");
                componentType = null;
            }
            this._name = newName = DslInfoUtilsKt.computeName$default(dimensionCombination, componentType, null, 4, null);
            return newName;
        }
        return currentName;
    }
}

