/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.cmake.server;

import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.internal.cxx.cmake.LinkLibrariesParserKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001*\u00020\u0003\u00a8\u0006\u0004"}, d2={"findRuntimeFiles", "", "Ljava/io/File;", "Lcom/android/build/gradle/external/cmake/server/Target;", "gradle-core"})
public final class ModelUtilsKt {
    @Nullable
    public static final List<File> findRuntimeFiles(@NotNull Target $this$findRuntimeFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$findRuntimeFiles, (String)"<this>");
        if ($this$findRuntimeFiles.linkLibraries == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)$this$findRuntimeFiles.type, (Object)"OBJECT_LIBRARY")) {
            return null;
        }
        Path sysroot = Paths.get($this$findRuntimeFiles.sysroot, new String[0]);
        List runtimeFiles = new ArrayList();
        for (String library : LinkLibrariesParserKt.parseLinkLibraries($this$findRuntimeFiles.linkLibraries)) {
            PathMatcher pathMatcher;
            Path path;
            Path path2;
            Path path3;
            if (StringsKt.startsWith$default((String)library, (String)"-", (boolean)false, (int)2, null)) continue;
            Path it = Paths.get(library, new String[0]);
            boolean bl = false;
            if (!it.isAbsolute()) {
                if ($this$findRuntimeFiles.buildDirectory == null) {
                    LoggingEnvironmentKt.warnln(CxxDiagnosticCode.CMAKE_SERVER_BUILD_DIRECTORY_MISSING, "Could not resolve path to '" + it + "' because CMake did not define build directory", new Object[0]);
                    path3 = null;
                } else {
                    path3 = Paths.get($this$findRuntimeFiles.buildDirectory, new String[0]).resolve(it);
                }
            } else {
                path3 = it;
            }
            if ((path2 = path3) == null || (path = path2.normalize()) == null) continue;
            Path libraryPath = path;
            if (libraryPath.startsWith(sysroot) || (pathMatcher = libraryPath.getFileSystem().getPathMatcher("glob:*.a")).matches(libraryPath.getFileName())) continue;
            File file = libraryPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            runtimeFiles.add(file);
        }
        return runtimeFiles;
    }
}

