/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.testing.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\u001a\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u001a\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u001a\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004\u001a\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0004\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0014\u001a\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"ABI_OFFSET", "", "API_OFFSET", "API_PREFIX", "", "SYSTEM_IMAGE_PREFIX", "VENDOR_OFFSET", "computeSystemImageHashFromDsl", "version", "imageSource", "abi", "computeVendorString", "computeVersionString", "isTvOrAutoDevice", "", "deviceName", "isTvOrAutoSource", "parseAbiFromHash", "systemImageHash", "parseApiFromHash", "(Ljava/lang/String;)Ljava/lang/Integer;", "parseVendorFromHash", "common"})
public final class ManagedDeviceUtilsKt {
    @NotNull
    private static final String SYSTEM_IMAGE_PREFIX = "system-images;";
    @NotNull
    private static final String API_PREFIX = "android-";
    private static final int API_OFFSET = 1;
    private static final int VENDOR_OFFSET = 2;
    private static final int ABI_OFFSET = 3;

    @NotNull
    public static final String computeSystemImageHashFromDsl(int version, @NotNull String imageSource, @NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return SYSTEM_IMAGE_PREFIX + ManagedDeviceUtilsKt.computeVersionString(version) + ";" + ManagedDeviceUtilsKt.computeVendorString(imageSource) + ";" + abi;
    }

    private static final String computeVersionString(int version) {
        return API_PREFIX + version;
    }

    @NotNull
    public static final String computeVendorString(@NotNull String imageSource) {
        String string;
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        switch (imageSource) {
            case "google": {
                string = "google_apis";
                break;
            }
            case "google-atd": {
                string = "google_atd";
                break;
            }
            case "aosp": {
                string = "default";
                break;
            }
            case "aosp-atd": {
                string = "aosp_atd";
                break;
            }
            default: {
                string = imageSource;
            }
        }
        return string;
    }

    public static final boolean isTvOrAutoSource(@NotNull String imageSource) {
        Intrinsics.checkNotNullParameter((Object)imageSource, (String)"imageSource");
        return StringsKt.contains$default((CharSequence)imageSource, (CharSequence)"-tv", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)imageSource, (CharSequence)"-auto", (boolean)false, (int)2, null);
    }

    public static final boolean isTvOrAutoDevice(@NotNull String deviceName) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        return StringsKt.contains$default((CharSequence)deviceName, (CharSequence)"TV", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)deviceName, (CharSequence)"Auto", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final Integer parseApiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        Object object = new String[]{";"};
        String apiComponent = (String)StringsKt.split$default((CharSequence)systemImageHash, (String[])object, (boolean)false, (int)0, (int)6, null).get(1);
        if (!StringsKt.startsWith$default((String)apiComponent, (String)API_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            object = Integer.parseInt(StringsKt.substringAfter$default((String)apiComponent, (String)API_PREFIX, null, (int)2, null));
        }
        catch (NumberFormatException e11) {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final String parseVendorFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2);
    }

    @Nullable
    public static final String parseAbiFromHash(@NotNull String systemImageHash) {
        Intrinsics.checkNotNullParameter((Object)systemImageHash, (String)"systemImageHash");
        String[] stringArray = new String[]{";"};
        return (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)systemImageHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)3);
    }
}

