/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.internal.ClientImpl;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import shadow.bundletool.com.android.ddmlib.jdwp.JdwpExtension;
import shadow.bundletool.com.android.ddmlib.jdwp.JdwpInterceptor;
import shadow.bundletool.com.android.ddmlib.jdwp.JdwpPipe;

public class DdmJdwpExtension
extends JdwpExtension {
    private final ConcurrentMap<Integer, ChunkHandler> mHandlerMap = new ConcurrentHashMap<Integer, ChunkHandler>();

    @Override
    public void intercept(ClientImpl client) {
        client.addJdwpInterceptor(new DdmInterceptor(client));
    }

    public void registerHandler(int type, ChunkHandler handler) {
        this.mHandlerMap.putIfAbsent(type, handler);
    }

    public void broadcast(Event event, ClientImpl client) {
        Log.d("ddms", "broadcast " + event + ": " + client);
        HashSet set = new HashSet(this.mHandlerMap.values());
        block6: for (ChunkHandler handler : set) {
            switch (event) {
                case CLIENT_READY: {
                    try {
                        handler.clientReady(client);
                        continue block6;
                    }
                    catch (IOException ioe) {
                        Log.w("ddms", "Got exception while broadcasting 'ready'");
                        return;
                    }
                }
                case CLIENT_DISCONNECTED: {
                    handler.clientDisconnected(client);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    public void ddmSeen(ClientImpl client) {
        if (!client.ddmSeen()) {
            this.broadcast(Event.CLIENT_READY, client);
        }
    }

    static boolean isDdmPacket(JdwpPacket packet) {
        return !packet.isReply() && packet.is(199, 1);
    }

    public class DdmInterceptor
    extends JdwpInterceptor {
        private final ClientImpl mClient;

        public DdmInterceptor(ClientImpl client) {
            this.mClient = client;
        }

        @Override
        public JdwpPacket intercept(JdwpPipe pipe, JdwpPacket packet) {
            if (DdmJdwpExtension.isDdmPacket(packet)) {
                DdmJdwpExtension.this.ddmSeen(this.mClient);
                ByteBuffer buf = packet.getPayload();
                int type = buf.getInt(buf.position());
                ChunkHandler handler = (ChunkHandler)DdmJdwpExtension.this.mHandlerMap.get(type);
                if (handler == null) {
                    Log.w("ddms", "Received unsupported chunk type " + ChunkHandler.name(type));
                } else {
                    handler.handlePacket(this.mClient, packet);
                }
                return null;
            }
            return packet;
        }
    }

    public static enum Event {
        CLIENT_READY,
        CLIENT_DISCONNECTED;

    }
}

