/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InclusiveIntRange {
    private final int min;
    private final int max;

    private InclusiveIntRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static InclusiveIntRange fromTo(int min, int max) {
        return new InclusiveIntRange(min, max);
    }

    public static InclusiveIntRange from(int min) {
        return new InclusiveIntRange(min, Integer.MAX_VALUE);
    }

    public List<InclusiveIntRange> getValuesNotIn(List<InclusiveIntRange> sortedNonOverlappingRanges) {
        if (sortedNonOverlappingRanges.isEmpty()) {
            return Collections.singletonList(this);
        }
        int testValue = this.min;
        List<InclusiveIntRange> result = null;
        for (InclusiveIntRange range : sortedNonOverlappingRanges) {
            int rangeMax = range.max;
            if (testValue > rangeMax) continue;
            int rangeMin = range.min;
            if (testValue < range.min) {
                if (result == null) {
                    result = new ArrayList<InclusiveIntRange>();
                }
                result.add(InclusiveIntRange.fromTo(testValue, rangeMin - 1));
            }
            if (rangeMax >= this.max) {
                return result != null ? result : Collections.emptyList();
            }
            testValue = rangeMax + 1;
        }
        if (testValue <= this.max) {
            if (result == null) {
                result = new ArrayList<InclusiveIntRange>(1);
            }
            result.add(InclusiveIntRange.fromTo(testValue, this.max));
        }
        return result != null ? result : Collections.emptyList();
    }

    public String toString() {
        return "[" + this.min + ", " + (this.max < Integer.MAX_VALUE ? this.max + "]" : "\u221e)");
    }
}

