/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Hints {
    public static final String PIN_HINT_ASSET_ZIP_ENTRY_NAME = "assets/com.android.hints.pins.txt";
    public static final String PIN_BYTE_RANGE_ZIP_ENTRY_NAME = "pinlist.meta";

    private static int clampToInt(long value) {
        return (int)Math.max(0L, Math.min(value, Integer.MAX_VALUE));
    }

    public static byte[] encodeByteRangeList(List<ByteRange> pinByteRanges) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(pinByteRanges.size() * 8);
        DataOutputStream out = new DataOutputStream(bos);
        try {
            for (ByteRange pinByteRange : pinByteRanges) {
                out.writeInt(Hints.clampToInt(pinByteRange.start));
                out.writeInt(Hints.clampToInt(pinByteRange.end - pinByteRange.start));
            }
        }
        catch (IOException ex2) {
            throw new AssertionError("impossible", ex2);
        }
        return bos.toByteArray();
    }

    public static ArrayList<PatternWithRange> parsePinPatterns(byte[] patternBlob) {
        ArrayList<PatternWithRange> pinPatterns = new ArrayList<PatternWithRange>();
        try {
            for (String rawLine : new String(patternBlob, "UTF-8").split("\n")) {
                String line = rawLine.replaceFirst("#.*", "");
                String[] fields = line.split(" ");
                if (fields.length == 1) {
                    pinPatterns.add(new PatternWithRange(fields[0]));
                    continue;
                }
                if (fields.length == 3) {
                    long start = Long.parseLong(fields[1]);
                    long end = Long.parseLong(fields[2]);
                    pinPatterns.add(new PatternWithRange(fields[0], start, end - start));
                    continue;
                }
                throw new AssertionError((Object)("bad pin pattern line " + line));
            }
        }
        catch (UnsupportedEncodingException ex2) {
            throw new RuntimeException("UTF-8 must be supported", ex2);
        }
        return pinPatterns;
    }

    public static final class PatternWithRange {
        final Pattern pattern;
        final long offset;
        final long size;

        public PatternWithRange(String pattern) {
            this.pattern = Pattern.compile(pattern);
            this.offset = 0L;
            this.size = Long.MAX_VALUE;
        }

        public PatternWithRange(String pattern, long offset, long size) {
            this.pattern = Pattern.compile(pattern);
            this.offset = offset;
            this.size = size;
        }

        public Matcher matcher(CharSequence input) {
            return this.pattern.matcher(input);
        }

        public ByteRange ClampToAbsoluteByteRange(ByteRange rangeIn) {
            if (rangeIn.end - rangeIn.start < this.offset) {
                return null;
            }
            long rangeOutStart = rangeIn.start + this.offset;
            long rangeOutSize = Math.min(rangeIn.end - rangeOutStart, this.size);
            return new ByteRange(rangeOutStart, rangeOutStart + rangeOutSize);
        }
    }

    public static final class ByteRange {
        final long start;
        final long end;

        public ByteRange(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

