/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public interface SizeFormatter {
    public String format(long var1);

    public static SizeFormatter rawFormatter() {
        return String::valueOf;
    }

    public static SizeFormatter humanReadableFormatter() {
        return new HumanReadableSizeFormatter();
    }

    public static class HumanReadableSizeFormatter
    implements SizeFormatter {
        private static final String[] UNIT_ABBREVIATIONS = new String[]{"B", "KB", "MB", "GB"};
        private static final long[] UNIT_SCALES = new long[]{1L, 1000L, 1000000L, 1000000000L};
        private static final long[] MIN_VALUE_IN_UNIT = new long[]{0L, 1000L, 999995L, 999995000L};

        @Override
        public String format(long sizeInBytes) {
            int unitIndex;
            for (unitIndex = UNIT_SCALES.length - 1; unitIndex > 0 && sizeInBytes < MIN_VALUE_IN_UNIT[unitIndex]; --unitIndex) {
            }
            return unitIndex == 0 ? HumanReadableSizeFormatter.formatBytes(sizeInBytes) : HumanReadableSizeFormatter.formatHigherUnit(sizeInBytes, UNIT_ABBREVIATIONS[unitIndex], UNIT_SCALES[unitIndex]);
        }

        private static String formatBytes(long sizeInBytes) {
            return String.format("%d B", sizeInBytes);
        }

        private static String formatHigherUnit(long sizeInBytes, String unitAbbreviation, long unitScale) {
            String formattedSize = new DecimalFormat("#.##").format(BigDecimal.valueOf(sizeInBytes).divide(BigDecimal.valueOf(unitScale)));
            return String.format("%s %s", formattedSize, unitAbbreviation);
        }

        private HumanReadableSizeFormatter() {
        }
    }
}

